/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import com.google.common.annotations.VisibleForTesting;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.schema.TableMetadata;

final class GossipInfoTable
extends AbstractVirtualTable {
    static final String TABLE_NAME = "gossip_info";
    static final String TABLE_COMMENT = "lists the gossip information for the cluster";
    static final String ADDRESS = "address";
    static final String PORT = "port";
    static final String HOSTNAME = "hostname";
    static final String GENERATION = "generation";
    static final String HEARTBEAT = "heartbeat";
    static final ApplicationState[] STATES_FOR_VERSIONS = ApplicationState.values();
    static final ApplicationState[] STATES_FOR_VALUES;
    private final Supplier<Map<InetAddressAndPort, EndpointState>> endpointStateMapSupplier;

    GossipInfoTable(String keyspace) {
        this(keyspace, () -> Gossiper.instance.endpointStateMap);
    }

    @VisibleForTesting
    GossipInfoTable(String keyspace, Supplier<Map<InetAddressAndPort, EndpointState>> endpointStateMapSupplier) {
        super(GossipInfoTable.buildTableMetadata(keyspace));
        this.endpointStateMapSupplier = endpointStateMapSupplier;
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        for (Map.Entry<InetAddressAndPort, EndpointState> entry : this.endpointStateMapSupplier.get().entrySet()) {
            InetAddressAndPort endpoint = entry.getKey();
            EndpointState localState = new EndpointState(entry.getValue());
            SimpleDataSet dataSet = result.row(endpoint.getAddress(), endpoint.getPort()).column(HOSTNAME, endpoint.getHostName()).column(GENERATION, this.getGeneration(localState)).column(HEARTBEAT, this.getHeartBeat(localState));
            for (ApplicationState state : STATES_FOR_VALUES) {
                dataSet.column(state.name().toLowerCase(), this.getValue(localState, state));
            }
            for (ApplicationState state : STATES_FOR_VERSIONS) {
                dataSet.column(state.name().toLowerCase() + "_version", this.getVersion(localState, state));
            }
        }
        return result;
    }

    private Integer getGeneration(EndpointState localState) {
        return localState == null ? null : Integer.valueOf(localState.getHeartBeatState().getGeneration());
    }

    private Integer getHeartBeat(EndpointState localState) {
        return localState == null ? null : Integer.valueOf(localState.getHeartBeatState().getHeartBeatVersion());
    }

    private String getValue(EndpointState localState, ApplicationState key) {
        VersionedValue value;
        return localState == null || (value = localState.getApplicationState(key)) == null ? null : value.value;
    }

    private Integer getVersion(EndpointState localState, ApplicationState key) {
        VersionedValue value;
        return localState == null || (value = localState.getApplicationState(key)) == null ? null : Integer.valueOf(value.version);
    }

    private static TableMetadata buildTableMetadata(String keyspace) {
        TableMetadata.Builder builder = TableMetadata.builder(keyspace, TABLE_NAME).comment(TABLE_COMMENT).kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(InetAddressType.instance)).addPartitionKeyColumn(ADDRESS, InetAddressType.instance).addClusteringColumn(PORT, Int32Type.instance).addRegularColumn(HOSTNAME, UTF8Type.instance).addRegularColumn(GENERATION, Int32Type.instance).addRegularColumn(HEARTBEAT, Int32Type.instance);
        for (ApplicationState state : STATES_FOR_VALUES) {
            builder.addRegularColumn(state.name().toLowerCase(), UTF8Type.instance);
        }
        for (ApplicationState state : STATES_FOR_VERSIONS) {
            builder.addRegularColumn(state.name().toLowerCase() + "_version", Int32Type.instance);
        }
        return builder.build();
    }

    static {
        EnumSet<ApplicationState> applicationStates = EnumSet.allOf(ApplicationState.class);
        applicationStates.remove((Object)ApplicationState.TOKENS);
        STATES_FOR_VALUES = applicationStates.toArray(new ApplicationState[0]);
    }
}

