/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import ch.qos.logback.classic.spi.LoggingEvent;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractMutableVirtualTable;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.schema.TableMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogMessagesTable
extends AbstractMutableVirtualTable {
    private static final Logger logger = LoggerFactory.getLogger(LogMessagesTable.class);
    public static final int LOGS_VIRTUAL_TABLE_MIN_ROWS = 1000;
    public static final int LOGS_VIRTUAL_TABLE_DEFAULT_ROWS = 50000;
    public static final int LOGS_VIRTUAL_TABLE_MAX_ROWS = 100000;
    public static final String TABLE_NAME = "system_logs";
    private static final String TABLE_COMMENT = "Cassandra logs";
    public static final String TIMESTAMP_COLUMN_NAME = "timestamp";
    public static final String LOGGER_COLUMN_NAME = "logger";
    public static final String ORDER_IN_MILLISECOND_COLUMN_NAME = "order_in_millisecond";
    public static final String LEVEL_COLUMN_NAME = "level";
    public static final String MESSAGE_COLUMN_NAME = "message";
    private final List<LogMessage> buffer;

    LogMessagesTable(String keyspace) {
        this(keyspace, LogMessagesTable.resolveBufferSize());
    }

    @VisibleForTesting
    LogMessagesTable(String keyspace, int size) {
        super(TableMetadata.builder(keyspace, TABLE_NAME).comment(TABLE_COMMENT).kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(TimestampType.instance)).addPartitionKeyColumn(TIMESTAMP_COLUMN_NAME, TimestampType.instance).addClusteringColumn(ORDER_IN_MILLISECOND_COLUMN_NAME, Int32Type.instance).addRegularColumn(LOGGER_COLUMN_NAME, UTF8Type.instance).addRegularColumn(LEVEL_COLUMN_NAME, UTF8Type.instance).addRegularColumn(MESSAGE_COLUMN_NAME, UTF8Type.instance).build());
        logger.debug("capacity of virtual table {} is set to be at most {} rows", (Object)this.metadata().toString(), (Object)size);
        this.buffer = BoundedLinkedList.create(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata(), DecoratedKey.comparator.reversed());
        List<LogMessage> list = this.buffer;
        synchronized (list) {
            long milliSecondsOfPreviousLog = 0L;
            int index = 0;
            ListIterator<LogMessage> iterator = this.buffer.listIterator();
            while (iterator.hasNext()) {
                LogMessage log = (LogMessage)iterator.next();
                long milliSecondsOfCurrentLog = log.timestamp;
                index = milliSecondsOfPreviousLog == milliSecondsOfCurrentLog ? ++index : 0;
                milliSecondsOfPreviousLog = milliSecondsOfCurrentLog;
                result.row(new Date(log.timestamp), index).column(LOGGER_COLUMN_NAME, log.logger).column(LEVEL_COLUMN_NAME, log.level).column(MESSAGE_COLUMN_NAME, log.message);
            }
        }
        return result;
    }

    public void add(LoggingEvent event) {
        this.buffer.add(new LogMessage(event));
    }

    @Override
    public void truncate() {
        this.buffer.clear();
    }

    @Override
    public boolean allowFilteringImplicitly() {
        return false;
    }

    @VisibleForTesting
    static int resolveBufferSize() {
        int size = CassandraRelevantProperties.LOGS_VIRTUAL_TABLE_MAX_ROWS.getInt();
        return size < 1000 || size > 100000 ? 50000 : size;
    }

    private static final class BoundedLinkedList<T>
    extends LinkedList<T> {
        private final int maxSize;

        public static <T> List<T> create(int size) {
            return Collections.synchronizedList(new BoundedLinkedList<T>(size));
        }

        private BoundedLinkedList(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public boolean add(T t) {
            if (this.size() == this.maxSize) {
                this.removeLast();
            }
            this.addFirst(t);
            return true;
        }
    }

    @VisibleForTesting
    public static class LogMessage {
        public final long timestamp;
        public final String logger;
        public final String level;
        public final String message;

        public LogMessage(LoggingEvent event) {
            this(event.getTimeStamp(), event.getLoggerName(), event.getLevel().toString(), event.getFormattedMessage());
        }

        public LogMessage(long timestamp, String logger, String level, String message) {
            this.timestamp = timestamp;
            this.logger = logger;
            this.level = level;
            this.message = message;
        }
    }
}

