/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.compilers;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.jci.compilers.AbstractJavaCompiler;
import org.apache.commons.jci.compilers.CompilationResult;
import org.apache.commons.jci.compilers.JavaCompilerSettings;
import org.apache.commons.jci.compilers.RhinoCompilationProblem;
import org.apache.commons.jci.compilers.RhinoJavaCompilerSettings;
import org.apache.commons.jci.problems.CompilationProblem;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.utils.ConversionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.optimizer.ClassCompiler;

public final class RhinoJavaCompiler
extends AbstractJavaCompiler {
    private final Log log = LogFactory.getLog((Class)RhinoJavaCompiler.class);
    private final JavaCompilerSettings defaultSettings = new RhinoJavaCompilerSettings();

    public CompilationResult compile(String[] pResourcePaths, ResourceReader pReader, ResourceStore pStore, ClassLoader pClassLoader, JavaCompilerSettings pSettings) {
        RhinoCompilingClassLoader cl = new RhinoCompilingClassLoader(pReader, pStore, pClassLoader);
        for (int i = 0; i < pResourcePaths.length; ++i) {
            this.log.debug((Object)("compiling " + pResourcePaths[i]));
            String clazzName = ConversionUtils.convertResourceToClassName((String)pResourcePaths[i]);
            try {
                cl.loadClass(clazzName);
                continue;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        Collection problems = cl.getProblems();
        CompilationProblem[] result = new CompilationProblem[problems.size()];
        problems.toArray(result);
        return new CompilationResult(result);
    }

    public JavaCompilerSettings createDefaultSettings() {
        return this.defaultSettings;
    }

    private final class RhinoCompilingClassLoader
    extends ClassLoader {
        private final ScriptableObject scope;
        private final ResourceReader reader;
        private final ResourceStore store;
        private final Collection problems;

        public RhinoCompilingClassLoader(ResourceReader pReader, ResourceStore pStore, ClassLoader pClassLoader) {
            super(pClassLoader);
            this.problems = new ArrayList();
            this.reader = pReader;
            this.store = pStore;
            Context context = Context.enter();
            this.scope = new ImporterTopLevel(context);
            Context.exit();
        }

        public Collection getProblems() {
            return this.problems;
        }

        protected Class findClass(String pName) throws ClassNotFoundException {
            Context context = Context.enter();
            context.setErrorReporter((ErrorReporter)new ProblemCollector());
            try {
                Class clazz = this.compileClass(context, pName);
                return clazz;
            }
            catch (EvaluatorException e) {
                throw new ClassNotFoundException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new ClassNotFoundException(e.getMessage(), e);
            }
            finally {
                Context.exit();
            }
        }

        private Class compileClass(Context pContext, String pClassName) throws IOException, ClassNotFoundException {
            Class[] interfaces;
            Class<?> superclass = null;
            String pSourceName = pClassName.replace('.', '/') + ".js";
            Scriptable target = this.evaluate(pContext, pSourceName);
            Object baseClassName = ScriptableObject.getProperty((Scriptable)target, (String)"__extends__");
            if (baseClassName instanceof String) {
                superclass = Class.forName((String)baseClassName);
            }
            ArrayList interfaceClasses = new ArrayList();
            Object interfaceNames = ScriptableObject.getProperty((Scriptable)target, (String)"__implements__");
            if (interfaceNames instanceof NativeArray) {
                NativeArray interfaceNameArray = (NativeArray)interfaceNames;
                int i = 0;
                while ((long)i < interfaceNameArray.getLength()) {
                    Object obj = interfaceNameArray.get(i, (Scriptable)interfaceNameArray);
                    if (obj instanceof String) {
                        interfaceClasses.add(Class.forName((String)obj));
                    }
                    ++i;
                }
            } else if (interfaceNames instanceof String) {
                interfaceClasses.add(Class.forName((String)interfaceNames));
            }
            if (!interfaceClasses.isEmpty()) {
                interfaces = new Class[interfaceClasses.size()];
                interfaceClasses.toArray(interfaces);
            } else {
                interfaces = null;
            }
            return this.compileClass(pContext, pSourceName, pClassName, superclass, interfaces);
        }

        private Class compileClass(Context pContext, String pSourceName, String pClassName, Class pSuperClass, Class[] pInterfaces) throws IOException {
            CompilerEnvirons environments = new CompilerEnvirons();
            environments.initFromContext(pContext);
            ClassCompiler compiler = new ClassCompiler(environments);
            if (pSuperClass != null) {
                compiler.setTargetExtends(pSuperClass);
            }
            if (pInterfaces != null) {
                compiler.setTargetImplements(pInterfaces);
            }
            byte[] sourceBytes = this.reader.getBytes(pSourceName);
            Object[] classes = compiler.compileToClassFiles(new String(sourceBytes), this.getName(pSourceName), 1, pClassName);
            GeneratedClassLoader loader = pContext.createClassLoader(pContext.getApplicationClassLoader());
            Class clazz = null;
            for (int i = 0; i < classes.length; i += 2) {
                String clazzName = (String)classes[i];
                byte[] clazzBytes = (byte[])classes[i + 1];
                this.store.write(clazzName.replace('.', '/') + ".class", clazzBytes);
                Class c = loader.defineClass(clazzName, clazzBytes);
                loader.linkClass(c);
                if (i != 0) continue;
                clazz = c;
            }
            return clazz;
        }

        private String getName(String s) {
            int i = s.lastIndexOf(47);
            if (i < 0) {
                return s;
            }
            return s.substring(i + 1);
        }

        private Scriptable evaluate(Context pContext, String pSourceName) throws JavaScriptException, IOException {
            if (!this.reader.isAvailable(pSourceName)) {
                throw new FileNotFoundException("File " + pSourceName + " not found");
            }
            Scriptable target = pContext.newObject((Scriptable)this.scope);
            byte[] sourceBytes = this.reader.getBytes(pSourceName);
            InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(sourceBytes));
            pContext.evaluateReader(target, (Reader)reader, this.getName(pSourceName), 1, null);
            return target;
        }

        private final class ProblemCollector
        implements ErrorReporter {
            private ProblemCollector() {
            }

            public void error(String pMessage, String pFileName, int pLine, String pScript, int pColumn) {
                RhinoCompilationProblem problem = new RhinoCompilationProblem(pMessage, pFileName, pLine, pScript, pColumn, true);
                if (((RhinoCompilingClassLoader)RhinoCompilingClassLoader.this).RhinoJavaCompiler.this.problemHandler != null) {
                    ((RhinoCompilingClassLoader)RhinoCompilingClassLoader.this).RhinoJavaCompiler.this.problemHandler.handle((CompilationProblem)problem);
                }
                RhinoCompilingClassLoader.this.problems.add(problem);
            }

            public void warning(String pMessage, String pFileName, int pLine, String pScript, int pColumn) {
                RhinoCompilationProblem problem = new RhinoCompilationProblem(pMessage, pFileName, pLine, pScript, pColumn, false);
                if (((RhinoCompilingClassLoader)RhinoCompilingClassLoader.this).RhinoJavaCompiler.this.problemHandler != null) {
                    ((RhinoCompilingClassLoader)RhinoCompilingClassLoader.this).RhinoJavaCompiler.this.problemHandler.handle((CompilationProblem)problem);
                }
                RhinoCompilingClassLoader.this.problems.add(problem);
            }

            public EvaluatorException runtimeError(String pMessage, String pFileName, int pLine, String pScript, int pColumn) {
                return new EvaluatorException(pMessage, pFileName, pLine, pScript, pColumn);
            }
        }
    }
}

