/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sourceforge.cobertura.coveragedata.LightClassmapListener;
import net.sourceforge.cobertura.coveragedata.TouchCollector;
import org.apache.commons.pool2.BaseObjectPool;
import org.apache.commons.pool2.PoolUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.LinkedBlockingDeque;
import org.apache.commons.pool2.impl.PooledSoftReference;

public class SoftReferenceObjectPool<T>
extends BaseObjectPool<T> {
    public static final transient int[] __cobertura_counters;
    private final PooledObjectFactory<T> factory;
    private final ReferenceQueue<T> refQueue;
    private int numActive;
    private long destroyCount;
    private long createCount;
    private final LinkedBlockingDeque<PooledSoftReference<T>> idleReferences;
    private final ArrayList<PooledSoftReference<T>> allReferences;

    /*
     * WARNING - void declaration
     */
    public SoftReferenceObjectPool(PooledObjectFactory<T> pooledObjectFactory) {
        void factory;
        int n = 0;
        __cobertura_counters[7] = __cobertura_counters[7] + 1;
        __cobertura_counters[1] = __cobertura_counters[1] + 1;
        this.refQueue = new ReferenceQueue();
        __cobertura_counters[2] = __cobertura_counters[2] + 1;
        this.numActive = 0;
        __cobertura_counters[3] = __cobertura_counters[3] + 1;
        this.destroyCount = 0L;
        __cobertura_counters[4] = __cobertura_counters[4] + 1;
        this.createCount = 0L;
        __cobertura_counters[5] = __cobertura_counters[5] + 1;
        this.idleReferences = new LinkedBlockingDeque();
        __cobertura_counters[6] = __cobertura_counters[6] + 1;
        this.allReferences = new ArrayList();
        __cobertura_counters[8] = __cobertura_counters[8] + 1;
        this.factory = factory;
        __cobertura_counters[9] = __cobertura_counters[9] + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized T borrowObject() throws Exception {
        int n = 0;
        __cobertura_counters[10] = __cobertura_counters[10] + 1;
        this.assertOpen();
        __cobertura_counters[11] = __cobertura_counters[11] + 1;
        Object obj = null;
        __cobertura_counters[12] = __cobertura_counters[12] + 1;
        boolean newlyCreated = false;
        __cobertura_counters[13] = __cobertura_counters[13] + 1;
        PooledSoftReference<Object> ref = null;
        while (true) {
            int n2;
            int n3 = n;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n = 0;
            __cobertura_counters[14] = __cobertura_counters[14] + 1;
            n = 16;
            if (null != obj) break;
            __cobertura_counters[15] = __cobertura_counters[15] + 1;
            n = 0;
            __cobertura_counters[17] = __cobertura_counters[17] + 1;
            n = 19;
            if (this.idleReferences.isEmpty()) {
                __cobertura_counters[18] = __cobertura_counters[18] + 1;
                n = 0;
                __cobertura_counters[20] = __cobertura_counters[20] + 1;
                n = 22;
                if (null == this.factory) {
                    __cobertura_counters[21] = __cobertura_counters[21] + 1;
                    n = 0;
                    __cobertura_counters[23] = __cobertura_counters[23] + 1;
                    throw new NoSuchElementException();
                }
                int n4 = n;
                __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                n = 0;
                __cobertura_counters[24] = __cobertura_counters[24] + 1;
                newlyCreated = true;
                __cobertura_counters[25] = __cobertura_counters[25] + 1;
                obj = this.factory.makeObject().getObject();
                __cobertura_counters[26] = __cobertura_counters[26] + 1;
                ++this.createCount;
                __cobertura_counters[27] = __cobertura_counters[27] + 1;
                ref = new PooledSoftReference<Object>(new SoftReference<Object>(obj));
                __cobertura_counters[28] = __cobertura_counters[28] + 1;
                this.allReferences.add(ref);
            } else {
                int n5 = n;
                __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
                n = 0;
                __cobertura_counters[29] = __cobertura_counters[29] + 1;
                ref = this.idleReferences.pollFirst();
                __cobertura_counters[30] = __cobertura_counters[30] + 1;
                obj = ref.getObject();
                __cobertura_counters[31] = __cobertura_counters[31] + 1;
                ref.getReference().clear();
                __cobertura_counters[32] = __cobertura_counters[32] + 1;
                ref.setReference(new SoftReference<Object>(obj));
            }
            __cobertura_counters[33] = __cobertura_counters[33] + 1;
            n = 35;
            if (null == this.factory) continue;
            __cobertura_counters[34] = __cobertura_counters[34] + 1;
            n = 0;
            n = 37;
            if (null == obj) continue;
            __cobertura_counters[36] = __cobertura_counters[36] + 1;
            n = 0;
            try {
                __cobertura_counters[38] = __cobertura_counters[38] + 1;
                this.factory.activateObject(ref);
                __cobertura_counters[39] = __cobertura_counters[39] + 1;
                n = 41;
                if (!this.factory.validateObject(ref)) {
                    __cobertura_counters[40] = __cobertura_counters[40] + 1;
                    n = 0;
                    __cobertura_counters[42] = __cobertura_counters[42] + 1;
                    throw new Exception("ValidateObject failed");
                }
                n2 = n;
            }
            catch (Throwable throwable) {
                __cobertura_counters[43] = __cobertura_counters[43] + 1;
                Throwable t = throwable;
                __cobertura_counters[44] = __cobertura_counters[44] + 1;
                PoolUtils.checkRethrow(t);
                try {
                    __cobertura_counters[45] = __cobertura_counters[45] + 1;
                    this.destroy(ref);
                }
                catch (Throwable throwable2) {
                    try {
                        __cobertura_counters[46] = __cobertura_counters[46] + 1;
                        Throwable t2 = throwable2;
                        __cobertura_counters[47] = __cobertura_counters[47] + 1;
                        PoolUtils.checkRethrow(t2);
                    }
                    catch (Throwable throwable3) {
                        __cobertura_counters[48] = __cobertura_counters[48] + 1;
                        Throwable throwable4 = throwable3;
                        obj = null;
                        throw throwable4;
                    }
                    __cobertura_counters[48] = __cobertura_counters[48] + 1;
                    obj = null;
                    __cobertura_counters[50] = __cobertura_counters[50] + 1;
                }
                __cobertura_counters[48] = __cobertura_counters[48] + 1;
                obj = null;
                __cobertura_counters[49] = __cobertura_counters[49] + 1;
                __cobertura_counters[51] = __cobertura_counters[51] + 1;
                n = 53;
                if (newlyCreated) {
                    __cobertura_counters[52] = __cobertura_counters[52] + 1;
                    n = 0;
                    __cobertura_counters[54] = __cobertura_counters[54] + 1;
                    __cobertura_counters[55] = __cobertura_counters[55] + 1;
                    throw new NoSuchElementException("Could not create a validated object, cause: " + t.getMessage());
                }
                int n6 = n;
                __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
                n = 0;
                __cobertura_counters[57] = __cobertura_counters[57] + 1;
                continue;
            }
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[56] = __cobertura_counters[56] + 1;
            continue;
            break;
        }
        int n7 = n;
        __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
        n = 0;
        __cobertura_counters[58] = __cobertura_counters[58] + 1;
        ++this.numActive;
        __cobertura_counters[59] = __cobertura_counters[59] + 1;
        ref.allocate();
        __cobertura_counters[60] = __cobertura_counters[60] + 1;
        return obj;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void returnObject(T t) throws Exception {
        int n;
        block16: {
            boolean bl;
            PooledSoftReference<void> ref;
            boolean success;
            block15: {
                void obj;
                boolean bl2;
                n = 0;
                __cobertura_counters[61] = __cobertura_counters[61] + 1;
                n = 63;
                if (!this.isClosed()) {
                    __cobertura_counters[62] = __cobertura_counters[62] + 1;
                    n = 0;
                    bl2 = true;
                } else {
                    int n2 = n;
                    __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                    n = 0;
                    bl2 = false;
                }
                success = bl2;
                __cobertura_counters[64] = __cobertura_counters[64] + 1;
                ref = this.findReference(obj);
                __cobertura_counters[65] = __cobertura_counters[65] + 1;
                n = 67;
                if (ref == null) {
                    __cobertura_counters[66] = __cobertura_counters[66] + 1;
                    n = 0;
                    __cobertura_counters[68] = __cobertura_counters[68] + 1;
                    throw new IllegalStateException("Returned object not currently part of this pool");
                }
                int n3 = n;
                __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                n = 0;
                __cobertura_counters[69] = __cobertura_counters[69] + 1;
                n = 71;
                if (this.factory != null) {
                    __cobertura_counters[70] = __cobertura_counters[70] + 1;
                    n = 0;
                    __cobertura_counters[72] = __cobertura_counters[72] + 1;
                    n = 74;
                    if (!this.factory.validateObject(ref)) {
                        __cobertura_counters[73] = __cobertura_counters[73] + 1;
                        n = 0;
                        __cobertura_counters[75] = __cobertura_counters[75] + 1;
                        success = false;
                    } else {
                        try {
                            int n4 = n;
                            __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                            n = 0;
                            __cobertura_counters[76] = __cobertura_counters[76] + 1;
                            this.factory.passivateObject(ref);
                        }
                        catch (Exception exception) {
                            __cobertura_counters[77] = __cobertura_counters[77] + 1;
                            Exception e = exception;
                            __cobertura_counters[78] = __cobertura_counters[78] + 1;
                            success = false;
                            break block15;
                        }
                        __cobertura_counters[79] = __cobertura_counters[79] + 1;
                    }
                }
            }
            int n5 = n;
            __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
            n = 0;
            __cobertura_counters[80] = __cobertura_counters[80] + 1;
            n = 82;
            if (!success) {
                __cobertura_counters[81] = __cobertura_counters[81] + 1;
                n = 0;
                bl = true;
            } else {
                int n6 = n;
                __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
                n = 0;
                bl = false;
            }
            boolean shouldDestroy = bl;
            __cobertura_counters[83] = __cobertura_counters[83] + 1;
            --this.numActive;
            __cobertura_counters[84] = __cobertura_counters[84] + 1;
            n = 86;
            if (success) {
                __cobertura_counters[85] = __cobertura_counters[85] + 1;
                n = 0;
                __cobertura_counters[87] = __cobertura_counters[87] + 1;
                ref.deallocate();
                __cobertura_counters[88] = __cobertura_counters[88] + 1;
                this.idleReferences.add(ref);
            }
            int n7 = n;
            __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
            n = 0;
            __cobertura_counters[89] = __cobertura_counters[89] + 1;
            this.notifyAll();
            __cobertura_counters[90] = __cobertura_counters[90] + 1;
            n = 92;
            if (shouldDestroy) {
                __cobertura_counters[91] = __cobertura_counters[91] + 1;
                n = 0;
                n = 94;
                if (this.factory != null) {
                    __cobertura_counters[93] = __cobertura_counters[93] + 1;
                    n = 0;
                    try {
                        __cobertura_counters[95] = __cobertura_counters[95] + 1;
                        this.destroy(ref);
                    }
                    catch (Exception exception) {
                        __cobertura_counters[96] = __cobertura_counters[96] + 1;
                        Exception exception2 = exception;
                        break block16;
                    }
                    __cobertura_counters[97] = __cobertura_counters[97] + 1;
                }
            }
        }
        int n8 = n;
        __cobertura_counters[n8] = __cobertura_counters[n8] + 1;
        n = 0;
        __cobertura_counters[98] = __cobertura_counters[98] + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void invalidateObject(T t) throws Exception {
        void obj;
        int n = 0;
        __cobertura_counters[99] = __cobertura_counters[99] + 1;
        PooledSoftReference<void> ref = this.findReference(obj);
        __cobertura_counters[100] = __cobertura_counters[100] + 1;
        n = 102;
        if (ref == null) {
            __cobertura_counters[101] = __cobertura_counters[101] + 1;
            n = 0;
            __cobertura_counters[103] = __cobertura_counters[103] + 1;
            throw new IllegalStateException("Object to invalidate is not currently part of this pool");
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[104] = __cobertura_counters[104] + 1;
        n = 106;
        if (this.factory != null) {
            __cobertura_counters[105] = __cobertura_counters[105] + 1;
            n = 0;
            __cobertura_counters[107] = __cobertura_counters[107] + 1;
            this.destroy(ref);
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[108] = __cobertura_counters[108] + 1;
        --this.numActive;
        __cobertura_counters[109] = __cobertura_counters[109] + 1;
        this.notifyAll();
        __cobertura_counters[110] = __cobertura_counters[110] + 1;
    }

    @Override
    public synchronized void addObject() throws Exception {
        boolean bl;
        int n = 0;
        __cobertura_counters[111] = __cobertura_counters[111] + 1;
        this.assertOpen();
        __cobertura_counters[112] = __cobertura_counters[112] + 1;
        n = 114;
        if (this.factory == null) {
            __cobertura_counters[113] = __cobertura_counters[113] + 1;
            n = 0;
            __cobertura_counters[115] = __cobertura_counters[115] + 1;
            throw new IllegalStateException("Cannot add objects without a factory.");
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[116] = __cobertura_counters[116] + 1;
        T obj = this.factory.makeObject().getObject();
        __cobertura_counters[117] = __cobertura_counters[117] + 1;
        ++this.createCount;
        __cobertura_counters[118] = __cobertura_counters[118] + 1;
        PooledSoftReference<T> ref = new PooledSoftReference<T>(new SoftReference<T>(obj, this.refQueue));
        __cobertura_counters[119] = __cobertura_counters[119] + 1;
        this.allReferences.add(ref);
        __cobertura_counters[120] = __cobertura_counters[120] + 1;
        boolean success = true;
        __cobertura_counters[121] = __cobertura_counters[121] + 1;
        n = 123;
        if (!this.factory.validateObject(ref)) {
            __cobertura_counters[122] = __cobertura_counters[122] + 1;
            n = 0;
            __cobertura_counters[124] = __cobertura_counters[124] + 1;
            success = false;
        } else {
            int n3 = n;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n = 0;
            __cobertura_counters[125] = __cobertura_counters[125] + 1;
            this.factory.passivateObject(ref);
        }
        __cobertura_counters[126] = __cobertura_counters[126] + 1;
        n = 128;
        if (!success) {
            __cobertura_counters[127] = __cobertura_counters[127] + 1;
            n = 0;
            bl = true;
        } else {
            int n4 = n;
            __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
            n = 0;
            bl = false;
        }
        boolean shouldDestroy = bl;
        __cobertura_counters[129] = __cobertura_counters[129] + 1;
        n = 131;
        if (success) {
            __cobertura_counters[130] = __cobertura_counters[130] + 1;
            n = 0;
            __cobertura_counters[132] = __cobertura_counters[132] + 1;
            this.idleReferences.add(ref);
            __cobertura_counters[133] = __cobertura_counters[133] + 1;
            this.notifyAll();
        }
        int n5 = n;
        __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
        n = 0;
        __cobertura_counters[134] = __cobertura_counters[134] + 1;
        n = 136;
        if (shouldDestroy) {
            __cobertura_counters[135] = __cobertura_counters[135] + 1;
            n = 0;
            try {
                __cobertura_counters[137] = __cobertura_counters[137] + 1;
                this.destroy(ref);
            }
            catch (Exception exception) {
                __cobertura_counters[138] = __cobertura_counters[138] + 1;
                Exception exception2 = exception;
            }
            __cobertura_counters[139] = __cobertura_counters[139] + 1;
        }
        int n6 = n;
        __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
        n = 0;
        __cobertura_counters[140] = __cobertura_counters[140] + 1;
    }

    @Override
    public synchronized int getNumIdle() {
        int n = 0;
        __cobertura_counters[141] = __cobertura_counters[141] + 1;
        this.pruneClearedReferences();
        __cobertura_counters[142] = __cobertura_counters[142] + 1;
        return this.idleReferences.size();
    }

    @Override
    public synchronized int getNumActive() {
        int n = 0;
        __cobertura_counters[143] = __cobertura_counters[143] + 1;
        return this.numActive;
    }

    @Override
    public synchronized void clear() {
        int n = 0;
        __cobertura_counters[144] = __cobertura_counters[144] + 1;
        n = 146;
        if (null != this.factory) {
            __cobertura_counters[145] = __cobertura_counters[145] + 1;
            n = 0;
            __cobertura_counters[147] = __cobertura_counters[147] + 1;
            Iterator<PooledSoftReference<T>> iter = this.idleReferences.iterator();
            while (true) {
                int n2;
                __cobertura_counters[148] = __cobertura_counters[148] + 1;
                n = 150;
                if (!iter.hasNext()) break;
                __cobertura_counters[149] = __cobertura_counters[149] + 1;
                n = 0;
                try {
                    __cobertura_counters[151] = __cobertura_counters[151] + 1;
                    PooledSoftReference<T> ref = iter.next();
                    __cobertura_counters[152] = __cobertura_counters[152] + 1;
                    n = 154;
                    if (null != ref.getObject()) {
                        __cobertura_counters[153] = __cobertura_counters[153] + 1;
                        n = 0;
                        __cobertura_counters[155] = __cobertura_counters[155] + 1;
                        this.factory.destroyObject(ref);
                    }
                    n2 = n;
                }
                catch (Exception exception) {
                    __cobertura_counters[156] = __cobertura_counters[156] + 1;
                    Exception exception2 = exception;
                    __cobertura_counters[158] = __cobertura_counters[158] + 1;
                    continue;
                }
                __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                n = 0;
                __cobertura_counters[157] = __cobertura_counters[157] + 1;
                continue;
                break;
            }
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[159] = __cobertura_counters[159] + 1;
        this.idleReferences.clear();
        __cobertura_counters[160] = __cobertura_counters[160] + 1;
        this.pruneClearedReferences();
        __cobertura_counters[161] = __cobertura_counters[161] + 1;
    }

    @Override
    public void close() {
        int n = 0;
        __cobertura_counters[162] = __cobertura_counters[162] + 1;
        super.close();
        __cobertura_counters[163] = __cobertura_counters[163] + 1;
        this.clear();
        __cobertura_counters[164] = __cobertura_counters[164] + 1;
    }

    public synchronized PooledObjectFactory<T> getFactory() {
        int n = 0;
        __cobertura_counters[165] = __cobertura_counters[165] + 1;
        return this.factory;
    }

    private void pruneClearedReferences() {
        int n = 0;
        __cobertura_counters[166] = __cobertura_counters[166] + 1;
        this.removeClearedReferences(this.idleReferences.iterator());
        __cobertura_counters[167] = __cobertura_counters[167] + 1;
        this.removeClearedReferences(this.allReferences.iterator());
        while (true) {
            __cobertura_counters[168] = __cobertura_counters[168] + 1;
            n = 170;
            if (this.refQueue.poll() == null) break;
            __cobertura_counters[169] = __cobertura_counters[169] + 1;
            n = 0;
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[171] = __cobertura_counters[171] + 1;
    }

    /*
     * WARNING - void declaration
     */
    private PooledSoftReference<T> findReference(T t) {
        int n = 0;
        __cobertura_counters[172] = __cobertura_counters[172] + 1;
        Iterator<PooledSoftReference<T>> iterator = this.allReferences.iterator();
        while (true) {
            __cobertura_counters[173] = __cobertura_counters[173] + 1;
            n = 175;
            if (!iterator.hasNext()) break;
            __cobertura_counters[174] = __cobertura_counters[174] + 1;
            n = 0;
            __cobertura_counters[176] = __cobertura_counters[176] + 1;
            PooledSoftReference<T> reference = iterator.next();
            __cobertura_counters[177] = __cobertura_counters[177] + 1;
            n = 179;
            if (reference.getObject() != null) {
                void obj;
                __cobertura_counters[178] = __cobertura_counters[178] + 1;
                n = 0;
                n = 181;
                if (reference.getObject().equals(obj)) {
                    __cobertura_counters[180] = __cobertura_counters[180] + 1;
                    n = 0;
                    __cobertura_counters[182] = __cobertura_counters[182] + 1;
                    return reference;
                }
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[183] = __cobertura_counters[183] + 1;
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[184] = __cobertura_counters[184] + 1;
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void destroy(PooledSoftReference<T> pooledSoftReference) throws Exception {
        void toDestroy;
        int n = 0;
        __cobertura_counters[185] = __cobertura_counters[185] + 1;
        toDestroy.invalidate();
        __cobertura_counters[186] = __cobertura_counters[186] + 1;
        this.idleReferences.remove(toDestroy);
        __cobertura_counters[187] = __cobertura_counters[187] + 1;
        this.allReferences.remove(toDestroy);
        try {
            __cobertura_counters[188] = __cobertura_counters[188] + 1;
            this.factory.destroyObject((PooledObject<T>)toDestroy);
        }
        catch (Throwable throwable) {
            __cobertura_counters[189] = __cobertura_counters[189] + 1;
            Throwable throwable2 = throwable;
            ++this.destroyCount;
            __cobertura_counters[190] = __cobertura_counters[190] + 1;
            toDestroy.getReference().clear();
            throw throwable2;
        }
        __cobertura_counters[189] = __cobertura_counters[189] + 1;
        ++this.destroyCount;
        __cobertura_counters[190] = __cobertura_counters[190] + 1;
        toDestroy.getReference().clear();
        __cobertura_counters[191] = __cobertura_counters[191] + 1;
        __cobertura_counters[192] = __cobertura_counters[192] + 1;
    }

    /*
     * WARNING - void declaration
     */
    private void removeClearedReferences(Iterator<PooledSoftReference<T>> iterator) {
        int n = 0;
        while (true) {
            void iterator2;
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[193] = __cobertura_counters[193] + 1;
            n = 195;
            if (!iterator2.hasNext()) break;
            __cobertura_counters[194] = __cobertura_counters[194] + 1;
            n = 0;
            __cobertura_counters[196] = __cobertura_counters[196] + 1;
            PooledSoftReference ref = (PooledSoftReference)iterator2.next();
            __cobertura_counters[197] = __cobertura_counters[197] + 1;
            n = 199;
            if (ref.getReference() != null) {
                __cobertura_counters[198] = __cobertura_counters[198] + 1;
                n = 0;
                n = 201;
                if (!ref.getReference().isEnqueued()) continue;
                __cobertura_counters[200] = __cobertura_counters[200] + 1;
                n = 0;
            }
            int n3 = n;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n = 0;
            __cobertura_counters[202] = __cobertura_counters[202] + 1;
            iterator2.remove();
        }
        int n4 = n;
        __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
        n = 0;
        __cobertura_counters[203] = __cobertura_counters[203] + 1;
    }

    static {
        SoftReferenceObjectPool.__cobertura_init();
    }

    public static void __cobertura_init() {
        if (__cobertura_counters == null) {
            __cobertura_counters = new int[204];
            TouchCollector.registerClass((String)"org/apache/commons/pool2/impl/SoftReferenceObjectPool");
        }
    }

    public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
        LightClassmapListener lightClassmapListener2 = lightClassmapListener;
        lightClassmapListener2.putLineTouchPoint(53, 1, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;)V");
        lightClassmapListener2.putLineTouchPoint(56, 2, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;)V");
        lightClassmapListener2.putLineTouchPoint(59, 3, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;)V");
        lightClassmapListener2.putLineTouchPoint(63, 4, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;)V");
        lightClassmapListener2.putLineTouchPoint(66, 5, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;)V");
        lightClassmapListener2.putLineTouchPoint(70, 6, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;)V");
        lightClassmapListener2.putLineTouchPoint(78, 7, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;)V");
        lightClassmapListener2.putLineTouchPoint(79, 8, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;)V");
        lightClassmapListener2.putLineTouchPoint(80, 9, "<init>", "(Lorg/apache/commons/pool2/PooledObjectFactory;)V");
        lightClassmapListener2.putLineTouchPoint(119, 10, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(120, 11, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(121, 12, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(122, 13, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(123, 14, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(123, 16, 15);
        lightClassmapListener2.putLineTouchPoint(124, 17, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(124, 19, 18);
        lightClassmapListener2.putLineTouchPoint(125, 20, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(125, 22, 21);
        lightClassmapListener2.putLineTouchPoint(126, 23, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(128, 24, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(129, 25, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(130, 26, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(132, 27, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(133, 28, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(136, 29, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(137, 30, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(141, 31, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(142, 32, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(144, 33, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(144, 35, 34);
        lightClassmapListener2.putJumpTouchPoint(144, 37, 36);
        lightClassmapListener2.putLineTouchPoint(146, 38, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(147, 39, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(147, 41, 40);
        lightClassmapListener2.putLineTouchPoint(148, 42, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(150, 43, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(151, 44, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(153, 45, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(154, 46, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(155, 47, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(158, 48, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(159, 49, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(159, 50, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(160, 51, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putJumpTouchPoint(160, 53, 52);
        lightClassmapListener2.putLineTouchPoint(161, 54, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(163, 55, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(165, 56, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(165, 57, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(168, 58, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(169, 59, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(170, 60, "borrowObject", "()Ljava/lang/Object;");
        lightClassmapListener2.putLineTouchPoint(194, 61, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(194, 63, 62);
        lightClassmapListener2.putLineTouchPoint(195, 64, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(196, 65, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(196, 67, 66);
        lightClassmapListener2.putLineTouchPoint(197, 68, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(200, 69, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(200, 71, 70);
        lightClassmapListener2.putLineTouchPoint(201, 72, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(201, 74, 73);
        lightClassmapListener2.putLineTouchPoint(202, 75, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(205, 76, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(206, 77, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(207, 78, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(208, 79, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(212, 80, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(212, 82, 81);
        lightClassmapListener2.putLineTouchPoint(213, 83, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(214, 84, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(214, 86, 85);
        lightClassmapListener2.putLineTouchPoint(217, 87, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(218, 88, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(220, 89, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(222, 90, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(222, 92, 91);
        lightClassmapListener2.putJumpTouchPoint(222, 94, 93);
        lightClassmapListener2.putLineTouchPoint(224, 95, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(225, 96, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(227, 97, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(229, 98, "returnObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(236, 99, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(237, 100, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(237, 102, 101);
        lightClassmapListener2.putLineTouchPoint(238, 103, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(241, 104, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putJumpTouchPoint(241, 106, 105);
        lightClassmapListener2.putLineTouchPoint(242, 107, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(244, 108, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(245, 109, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(246, 110, "invalidateObject", "(Ljava/lang/Object;)V");
        lightClassmapListener2.putLineTouchPoint(272, 111, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(273, 112, "addObject", "()V");
        lightClassmapListener2.putJumpTouchPoint(273, 114, 113);
        lightClassmapListener2.putLineTouchPoint(274, 115, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(277, 116, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(278, 117, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(280, 118, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(282, 119, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(284, 120, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(285, 121, "addObject", "()V");
        lightClassmapListener2.putJumpTouchPoint(285, 123, 122);
        lightClassmapListener2.putLineTouchPoint(286, 124, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(288, 125, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(291, 126, "addObject", "()V");
        lightClassmapListener2.putJumpTouchPoint(291, 128, 127);
        lightClassmapListener2.putLineTouchPoint(292, 129, "addObject", "()V");
        lightClassmapListener2.putJumpTouchPoint(292, 131, 130);
        lightClassmapListener2.putLineTouchPoint(293, 132, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(294, 133, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(297, 134, "addObject", "()V");
        lightClassmapListener2.putJumpTouchPoint(297, 136, 135);
        lightClassmapListener2.putLineTouchPoint(299, 137, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(300, 138, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(302, 139, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(304, 140, "addObject", "()V");
        lightClassmapListener2.putLineTouchPoint(314, 141, "getNumIdle", "()I");
        lightClassmapListener2.putLineTouchPoint(315, 142, "getNumIdle", "()I");
        lightClassmapListener2.putLineTouchPoint(325, 143, "getNumActive", "()I");
        lightClassmapListener2.putLineTouchPoint(333, 144, "clear", "()V");
        lightClassmapListener2.putJumpTouchPoint(333, 146, 145);
        lightClassmapListener2.putLineTouchPoint(334, 147, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(335, 148, "clear", "()V");
        lightClassmapListener2.putJumpTouchPoint(335, 150, 149);
        lightClassmapListener2.putLineTouchPoint(337, 151, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(338, 152, "clear", "()V");
        lightClassmapListener2.putJumpTouchPoint(338, 154, 153);
        lightClassmapListener2.putLineTouchPoint(339, 155, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(341, 156, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(343, 157, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(343, 158, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(346, 159, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(347, 160, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(348, 161, "clear", "()V");
        lightClassmapListener2.putLineTouchPoint(360, 162, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(361, 163, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(362, 164, "close", "()V");
        lightClassmapListener2.putLineTouchPoint(371, 165, "getFactory", "()Lorg/apache/commons/pool2/PooledObjectFactory;");
        lightClassmapListener2.putLineTouchPoint(380, 166, "pruneClearedReferences", "()V");
        lightClassmapListener2.putLineTouchPoint(381, 167, "pruneClearedReferences", "()V");
        lightClassmapListener2.putLineTouchPoint(382, 168, "pruneClearedReferences", "()V");
        lightClassmapListener2.putJumpTouchPoint(382, 170, 169);
        lightClassmapListener2.putLineTouchPoint(383, 171, "pruneClearedReferences", "()V");
        lightClassmapListener2.putLineTouchPoint(392, 172, "findReference", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/PooledSoftReference;");
        lightClassmapListener2.putLineTouchPoint(393, 173, "findReference", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/PooledSoftReference;");
        lightClassmapListener2.putJumpTouchPoint(393, 175, 174);
        lightClassmapListener2.putLineTouchPoint(394, 176, "findReference", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/PooledSoftReference;");
        lightClassmapListener2.putLineTouchPoint(395, 177, "findReference", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/PooledSoftReference;");
        lightClassmapListener2.putJumpTouchPoint(395, 179, 178);
        lightClassmapListener2.putJumpTouchPoint(395, 181, 180);
        lightClassmapListener2.putLineTouchPoint(396, 182, "findReference", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/PooledSoftReference;");
        lightClassmapListener2.putLineTouchPoint(398, 183, "findReference", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/PooledSoftReference;");
        lightClassmapListener2.putLineTouchPoint(399, 184, "findReference", "(Ljava/lang/Object;)Lorg/apache/commons/pool2/impl/PooledSoftReference;");
        lightClassmapListener2.putLineTouchPoint(411, 185, "destroy", "(Lorg/apache/commons/pool2/impl/PooledSoftReference;)V");
        lightClassmapListener2.putLineTouchPoint(412, 186, "destroy", "(Lorg/apache/commons/pool2/impl/PooledSoftReference;)V");
        lightClassmapListener2.putLineTouchPoint(413, 187, "destroy", "(Lorg/apache/commons/pool2/impl/PooledSoftReference;)V");
        lightClassmapListener2.putLineTouchPoint(415, 188, "destroy", "(Lorg/apache/commons/pool2/impl/PooledSoftReference;)V");
        lightClassmapListener2.putLineTouchPoint(417, 189, "destroy", "(Lorg/apache/commons/pool2/impl/PooledSoftReference;)V");
        lightClassmapListener2.putLineTouchPoint(418, 190, "destroy", "(Lorg/apache/commons/pool2/impl/PooledSoftReference;)V");
        lightClassmapListener2.putLineTouchPoint(419, 191, "destroy", "(Lorg/apache/commons/pool2/impl/PooledSoftReference;)V");
        lightClassmapListener2.putLineTouchPoint(420, 192, "destroy", "(Lorg/apache/commons/pool2/impl/PooledSoftReference;)V");
        lightClassmapListener2.putLineTouchPoint(428, 193, "removeClearedReferences", "(Ljava/util/Iterator;)V");
        lightClassmapListener2.putJumpTouchPoint(428, 195, 194);
        lightClassmapListener2.putLineTouchPoint(429, 196, "removeClearedReferences", "(Ljava/util/Iterator;)V");
        lightClassmapListener2.putLineTouchPoint(430, 197, "removeClearedReferences", "(Ljava/util/Iterator;)V");
        lightClassmapListener2.putJumpTouchPoint(430, 199, 198);
        lightClassmapListener2.putJumpTouchPoint(430, 201, 200);
        lightClassmapListener2.putLineTouchPoint(431, 202, "removeClearedReferences", "(Ljava/util/Iterator;)V");
        lightClassmapListener2.putLineTouchPoint(434, 203, "removeClearedReferences", "(Ljava/util/Iterator;)V");
    }

    public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
        LightClassmapListener lightClassmapListener2 = lightClassmapListener;
        lightClassmapListener2.setClazz("org/apache/commons/pool2/impl/SoftReferenceObjectPool");
        lightClassmapListener2.setSource("SoftReferenceObjectPool.java");
        SoftReferenceObjectPool.__cobertura_classmap_0(lightClassmapListener2);
    }

    public static int[] __cobertura_get_and_reset_counters() {
        int[] nArray = __cobertura_counters;
        __cobertura_counters = new int[__cobertura_counters.length];
        return nArray;
    }
}

