/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.curator-test.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryUtils {
    private static final Logger log = LoggerFactory.getLogger(DirectoryUtils.class);

    public static File createTempDirectory() {
        try {
            Path tempDirectory = Files.createTempDirectory(DirectoryUtils.class.getSimpleName(), new FileAttribute[0]);
            return tempDirectory.toFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void deleteRecursively(File file) throws IOException {
        if (file.isDirectory()) {
            DirectoryUtils.deleteDirectoryContents(file);
        }
        if (!file.delete()) {
            log.error("Failed to delete " + file);
        }
    }

    public static void deleteDirectoryContents(File directory) throws IOException {
        Preconditions.checkArgument(directory.isDirectory(), "Not a directory: %s", (Object)directory);
        File[] files = directory.listFiles();
        if (files == null) {
            log.warn("directory.listFiles() returned null for: " + directory);
            return;
        }
        for (File file : files) {
            DirectoryUtils.deleteRecursively(file);
        }
    }
}

