/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.collection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapType
extends Type {
    private Type keyType;
    private Type valueType;
    private QName keyName;
    private QName valueName;
    private QName entryName;

    public MapType(QName schemaType, Type keyType, Type valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.setSchemaType(schemaType);
        this.keyName = new QName(schemaType.getNamespaceURI(), "key");
        this.valueName = new QName(schemaType.getNamespaceURI(), "value");
        this.entryName = new QName(schemaType.getNamespaceURI(), "entry");
    }

    @Override
    public Object readObject(MessageReader reader, Context context) throws DatabindingException {
        Map<Object, Object> map = this.instantiateMap();
        try {
            Type kType = this.getKeyType();
            Type vType = this.getValueType();
            while (reader.hasMoreElementReaders()) {
                MessageReader entryReader = reader.getNextElementReader();
                if (entryReader.getName().equals(this.getEntryName())) {
                    Object key = null;
                    Object value = null;
                    while (entryReader.hasMoreElementReaders()) {
                        MessageReader evReader = entryReader.getNextElementReader();
                        if (evReader.getName().equals(this.getKeyName())) {
                            key = kType.readObject(evReader, context);
                            continue;
                        }
                        if (evReader.getName().equals(this.getValueName())) {
                            value = vType.readObject(evReader, context);
                            continue;
                        }
                        this.readToEnd(evReader);
                    }
                    map.put(key, value);
                    continue;
                }
                this.readToEnd(entryReader);
            }
            return map;
        }
        catch (IllegalArgumentException e) {
            throw new DatabindingException("Illegal argument.", (Throwable)e);
        }
    }

    private void readToEnd(MessageReader childReader) {
        while (childReader.hasMoreElementReaders()) {
            this.readToEnd(childReader.getNextElementReader());
        }
    }

    protected Map<Object, Object> instantiateMap() {
        Map<Object, Object> map = null;
        if (this.getTypeClass().equals(Map.class)) {
            map = new HashMap<Object, Object>();
        } else if (this.getTypeClass().equals(Hashtable.class)) {
            map = new Hashtable();
        } else if (this.getTypeClass().isInterface()) {
            map = new HashMap();
        } else {
            try {
                map = (Map)this.getTypeClass().newInstance();
            }
            catch (Exception e) {
                throw new DatabindingException("Could not create map implementation: " + this.getTypeClass().getName(), (Throwable)e);
            }
        }
        return map;
    }

    @Override
    public void writeObject(Object object, MessageWriter writer, Context context) throws DatabindingException {
        if (object == null) {
            return;
        }
        try {
            Map map = (Map)object;
            Type kType = this.getKeyType();
            Type vType = this.getValueType();
            for (Map.Entry entry : map.entrySet()) {
                this.writeEntry(writer, context, kType, vType, entry);
            }
        }
        catch (IllegalArgumentException e) {
            throw new DatabindingException("Illegal argument.", (Throwable)e);
        }
    }

    private void writeEntry(MessageWriter writer, Context context, Type kType, Type vType, Map.Entry entry) throws DatabindingException {
        kType = TypeUtil.getWriteType(context.getGlobalContext(), entry.getKey(), kType);
        vType = TypeUtil.getWriteType(context.getGlobalContext(), entry.getValue(), vType);
        MessageWriter entryWriter = writer.getElementWriter(this.getEntryName());
        MessageWriter keyWriter = entryWriter.getElementWriter(this.getKeyName());
        kType.writeObject(entry.getKey(), keyWriter, context);
        keyWriter.close();
        MessageWriter valueWriter = entryWriter.getElementWriter(this.getValueName());
        vType.writeObject(entry.getValue(), valueWriter, context);
        valueWriter.close();
        entryWriter.close();
    }

    @Override
    public void writeSchema(XmlSchema root) {
        XmlSchemaComplexType complex = new XmlSchemaComplexType(root);
        complex.setName(this.getSchemaType().getLocalPart());
        root.addType((XmlSchemaType)complex);
        root.getItems().add((XmlSchemaObject)complex);
        XmlSchemaSequence sequence = new XmlSchemaSequence();
        complex.setParticle((XmlSchemaParticle)sequence);
        Type kType = this.getKeyType();
        Type vType = this.getValueType();
        XmlSchemaElement element = new XmlSchemaElement();
        sequence.getItems().add((XmlSchemaObject)element);
        element.setName(this.getEntryName().getLocalPart());
        element.setMinOccurs(0L);
        element.setMaxOccurs(Long.MAX_VALUE);
        XmlSchemaComplexType evType = new XmlSchemaComplexType(root);
        element.setType((XmlSchemaType)evType);
        XmlSchemaSequence evSequence = new XmlSchemaSequence();
        evType.setParticle((XmlSchemaParticle)evSequence);
        this.createElement(evSequence, this.getKeyName(), kType);
        this.createElement(evSequence, this.getValueName(), vType);
    }

    private void createElement(XmlSchemaSequence seq, QName name, Type type) {
        XmlSchemaElement element = new XmlSchemaElement();
        seq.getItems().add((XmlSchemaObject)element);
        element.setName(name.getLocalPart());
        element.setSchemaTypeName(type.getSchemaType());
        element.setMinOccurs(0L);
        element.setMaxOccurs(1L);
    }

    @Override
    public Set<Type> getDependencies() {
        HashSet<Type> deps = new HashSet<Type>();
        deps.add(this.getKeyType());
        deps.add(this.getValueType());
        return deps;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getValueType() {
        return this.valueType;
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    public QName getKeyName() {
        return this.keyName;
    }

    public void setKeyName(QName keyName) {
        this.keyName = keyName;
    }

    public QName getValueName() {
        return this.valueName;
    }

    public void setValueName(QName valueName) {
        this.valueName = valueName;
    }

    public QName getEntryName() {
        return this.entryName;
    }

    public void setEntryName(QName entryName) {
        this.entryName = entryName;
    }
}

