/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.SubresourceKey;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassResourceInfo
extends AbstractResourceInfo {
    private URITemplate uriTemplate;
    private MethodDispatcher methodDispatcher;
    private ResourceProvider resourceProvider;
    private ConcurrentHashMap<SubresourceKey, ClassResourceInfo> subResources = new ConcurrentHashMap();
    private List<Field> paramFields;
    private List<Method> paramMethods;
    private boolean enableStatic;
    private boolean createdFromModel;

    public ClassResourceInfo(Class<?> theResourceClass) {
        this(theResourceClass, false);
    }

    public ClassResourceInfo(Class<?> theResourceClass, boolean theRoot) {
        this(theResourceClass, theResourceClass, theRoot);
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> theServiceClass) {
        this(theResourceClass, theServiceClass, false);
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> theServiceClass, boolean theRoot) {
        this(theResourceClass, theServiceClass, theRoot, false);
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> theServiceClass, boolean theRoot, boolean enableStatic) {
        super(theResourceClass, theServiceClass, theRoot);
        this.enableStatic = enableStatic;
        if (theRoot) {
            this.initParamFields();
            this.initParamMethods();
        }
    }

    public ClassResourceInfo(Class<?> theResourceClass, Class<?> theServiceClass, boolean theRoot, boolean enableStatic, boolean createdFromModel) {
        super(theResourceClass, theServiceClass, theRoot);
        this.enableStatic = enableStatic;
        if (theRoot) {
            this.initParamFields();
            this.initParamMethods();
        }
        this.createdFromModel = createdFromModel;
    }

    public ClassResourceInfo findResource(Class<?> typedClass, Class<?> instanceClass) {
        instanceClass = this.enableStatic ? typedClass : instanceClass;
        SubresourceKey key = new SubresourceKey(typedClass, instanceClass);
        return this.subResources.get(key);
    }

    public ClassResourceInfo getSubResource(Class<?> typedClass, Class<?> instanceClass) {
        instanceClass = this.enableStatic ? typedClass : instanceClass;
        SubresourceKey key = new SubresourceKey(typedClass, instanceClass);
        ClassResourceInfo cri = this.subResources.get(key);
        if (cri == null && !this.enableStatic && (cri = ResourceUtils.createClassResourceInfo(typedClass, instanceClass, false, this.enableStatic)) != null) {
            this.subResources.putIfAbsent(key, cri);
        }
        return cri;
    }

    public Collection<ClassResourceInfo> getSubResources() {
        return Collections.unmodifiableCollection(this.subResources.values());
    }

    public Set<String> getAllowedMethods() {
        HashSet<String> methods = new HashSet<String>();
        for (OperationResourceInfo o : this.methodDispatcher.getOperationResourceInfos()) {
            String method = o.getHttpMethod();
            if (method == null) continue;
            methods.add(method);
        }
        return methods;
    }

    private void initParamFields() {
        if (this.getResourceClass() == null || !this.isRoot()) {
            return;
        }
        for (Field f : this.getServiceClass().getDeclaredFields()) {
            for (Annotation a : f.getAnnotations()) {
                if (!AnnotationUtils.isParamAnnotationClass(a.annotationType())) continue;
                if (this.paramFields == null) {
                    this.paramFields = new ArrayList<Field>();
                }
                this.paramFields.add(f);
            }
        }
    }

    private void initParamMethods() {
        block0: for (Method m : this.getServiceClass().getMethods()) {
            if (!m.getName().startsWith("set") || m.getParameterTypes().length != 1) continue;
            for (Annotation a : m.getAnnotations()) {
                if (!AnnotationUtils.isParamAnnotationClass(a.annotationType())) continue;
                this.checkParamMethod(m, AnnotationUtils.getAnnotationValue(a));
                continue block0;
            }
        }
    }

    public URITemplate getURITemplate() {
        return this.uriTemplate;
    }

    public void setURITemplate(URITemplate u) {
        this.uriTemplate = u;
    }

    public MethodDispatcher getMethodDispatcher() {
        return this.methodDispatcher;
    }

    public void setMethodDispatcher(MethodDispatcher md) {
        this.methodDispatcher = md;
    }

    public boolean hasSubResources() {
        return !this.subResources.isEmpty();
    }

    public void addSubClassResourceInfo(ClassResourceInfo cri) {
        this.subResources.putIfAbsent(new SubresourceKey(cri.getResourceClass(), cri.getServiceClass()), cri);
    }

    public boolean isCreatedFromModel() {
        return this.createdFromModel;
    }

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public void setResourceProvider(ResourceProvider rp) {
        this.resourceProvider = rp;
    }

    public Produces getProduceMime() {
        return AnnotationUtils.getClassAnnotation(this.getServiceClass(), Produces.class);
    }

    public Consumes getConsumeMime() {
        return AnnotationUtils.getClassAnnotation(this.getServiceClass(), Consumes.class);
    }

    public Path getPath() {
        return AnnotationUtils.getClassAnnotation(this.getServiceClass(), Path.class);
    }

    private void addParamMethod(Method m) {
        if (this.paramMethods == null) {
            this.paramMethods = new ArrayList<Method>();
        }
        this.paramMethods.add(m);
    }

    public List<Method> getParameterMethods() {
        return this.paramMethods == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.paramMethods);
    }

    public List<Field> getParameterFields() {
        return this.paramFields == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.paramFields);
    }

    private void checkParamMethod(Method m, String value) {
        if (m.getName().equalsIgnoreCase("set" + value)) {
            this.addParamMethod(m);
        }
    }

    @Override
    public boolean isSingleton() {
        return this.resourceProvider != null && this.resourceProvider.isSingleton();
    }
}

