/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.logging.atom.deliverer;

import java.util.Calendar;
import java.util.Date;
import org.apache.abdera.model.Element;
import org.apache.commons.lang.Validate;
import org.apache.cxf.management.web.logging.atom.deliverer.Deliverer;

public final class RetryingDeliverer
implements Deliverer {
    private Deliverer deliverer;
    private PauseCalculator pauser;
    private int timeout;

    public RetryingDeliverer(Deliverer worker, int timeout, int pause, boolean linear) {
        Validate.notNull((Object)worker, (String)"worker is null");
        Validate.isTrue((timeout >= 0 ? 1 : 0) != 0, (String)"timeout is negative");
        Validate.isTrue((pause > 0 ? 1 : 0) != 0, (String)"pause is not greater than zero");
        this.deliverer = worker;
        this.timeout = timeout;
        this.pauser = linear ? new ConstantPause(pause) : new ExponentialPause(pause);
    }

    public RetryingDeliverer(Deliverer worker, int timeout, PauseCalculator strategy) {
        Validate.notNull((Object)worker, (String)"worker is null");
        Validate.notNull((Object)strategy, (String)"strategy is null");
        Validate.isTrue((timeout >= 0 ? 1 : 0) != 0, (String)"timeout is negative");
        this.deliverer = worker;
        this.pauser = strategy;
        this.timeout = timeout;
    }

    public boolean deliver(Element element) throws InterruptedException {
        Calendar cal = Calendar.getInstance();
        cal.add(13, this.timeout);
        Date timeoutDate = cal.getTime();
        while (!this.deliverer.deliver(element)) {
            int sleep = this.pauser.nextPause();
            cal = Calendar.getInstance();
            cal.add(13, sleep);
            if (this.timeout == 0 || timeoutDate.after(cal.getTime())) {
                Thread.sleep(sleep * 1000);
                continue;
            }
            this.pauser.reset();
            return false;
        }
        this.pauser.reset();
        return true;
    }

    public String getEndpointAddress() {
        return this.deliverer.getEndpointAddress();
    }

    private static class ExponentialPause
    implements PauseCalculator {
        private int pause;
        private int current;

        public ExponentialPause(int pause) {
            this.pause = pause;
            this.current = pause;
        }

        public int nextPause() {
            int c = this.current;
            this.current *= 2;
            return c;
        }

        public void reset() {
            this.current = this.pause;
        }
    }

    private static class ConstantPause
    implements PauseCalculator {
        private int pause;

        public ConstantPause(int pause) {
            this.pause = pause;
        }

        public int nextPause() {
            return this.pause;
        }

        public void reset() {
        }
    }

    public static interface PauseCalculator {
        public int nextPause();

        public void reset();
    }
}

