/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.client.service.settings;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cxf.management.web.browser.client.event.ChangedSubscriptionsEvent;
import org.apache.cxf.management.web.browser.client.service.settings.IdentifierGenerator;
import org.apache.cxf.management.web.browser.client.service.settings.RemoteStorageProxy;
import org.apache.cxf.management.web.browser.client.service.settings.RemoteStorageProxyImpl;
import org.apache.cxf.management.web.browser.client.service.settings.Settings;
import org.apache.cxf.management.web.browser.client.service.settings.Subscription;

@Singleton
public class SettingsFacade {
    @Nonnull
    private final RemoteStorageProxy remoteStorage;
    @Nonnull
    private final EventBus eventBus;
    @Nullable
    private StorageLayer storageLayer;
    @Nonnull
    private final IdentifierGenerator identifierGenerator;
    private boolean initialized;

    @Inject
    public SettingsFacade(@Nonnull RemoteStorageProxy remoteStorage, @Nonnull EventBus eventBus, @Nonnull IdentifierGenerator identifierGenerator) {
        this.remoteStorage = remoteStorage;
        this.eventBus = eventBus;
        this.identifierGenerator = identifierGenerator;
    }

    public void initialize(@Nonnull StorageStrategy strategy) {
        this.storageLayer = this.createStorageLayers(strategy);
        this.storageLayer.initialize();
        this.initialized = true;
    }

    public void addSubscription(@Nonnull String name, @Nonnull String url) {
        assert (!"".equals(name));
        assert (!"".equals(url));
        assert (this.storageLayer != null);
        this.isValid();
        String id = this.identifierGenerator.generateUUID();
        assert (id != null && !"".equals(id));
        this.storageLayer.getSettings().getSubscriptions().add(new Subscription(id, name, url));
        this.storageLayer.update();
    }

    public void updateSubscription(@Nonnull Subscription subscription) {
        assert (subscription.getUrl() != null && !"".equals(subscription.getUrl()));
        assert (this.storageLayer != null);
        this.isValid();
        this.storageLayer.getSettings().getSubscriptions().remove(subscription);
        this.storageLayer.getSettings().getSubscriptions().add(subscription);
        this.storageLayer.update();
    }

    public void removeSubscription(@Nonnull Subscription subscription) {
        assert (subscription.getUrl() != null && !"".equals(subscription.getUrl()));
        assert (this.storageLayer != null);
        this.isValid();
        this.storageLayer.getSettings().getSubscriptions().remove(subscription);
        this.storageLayer.update();
    }

    @Nonnull
    public List<Subscription> getSubscriptions() {
        assert (this.storageLayer != null);
        this.isValid();
        return new ArrayList<Subscription>(this.storageLayer.getSettings().getSubscriptions());
    }

    private void isValid() {
        if (!this.initialized) {
            throw new IllegalStateException("Storage layers not initialized");
        }
    }

    @Nonnull
    private StorageLayer createStorageLayers(@Nonnull StorageStrategy storageStrategy) {
        switch (storageStrategy) {
            case REMOTE: {
                return new RemoteStorageLayer(this.remoteStorage, new MemoryStorageLayer());
            }
        }
        throw new IllegalArgumentException("Unknown storage strategy type");
    }

    private class RemoteStorageLayer
    implements StorageLayer {
        @Nonnull
        private final StorageLayer parent;
        @Nonnull
        private final RemoteStorageProxy remoteStorage;

        RemoteStorageLayer(@Nonnull RemoteStorageProxy remoteStorage, StorageLayer parent) {
            this.parent = parent;
            this.remoteStorage = remoteStorage;
        }

        @Override
        public boolean initialize() {
            boolean isSuccess = this.parent.initialize();
            if (!isSuccess) {
                this.remoteStorage.saveSettings(new RemoteStorageProxyImpl.Callback(){

                    @Override
                    public void onSuccess(@Nullable Settings retrievedSettings) {
                        Settings settings = retrievedSettings != null ? retrievedSettings : new Settings();
                        RemoteStorageLayer.this.parent.update(settings);
                        SettingsFacade.this.eventBus.fireEvent((GwtEvent)new ChangedSubscriptionsEvent());
                    }
                });
            }
            return true;
        }

        @Override
        @Nonnull
        public Settings getSettings() {
            return this.parent.getSettings();
        }

        @Override
        public void update(@Nonnull Settings settings) {
            assert (settings != null);
            this.parent.update(settings);
            this.remoteStorage.retrieveSettings(settings, new RemoteStorageProxyImpl.NoActionCallback());
        }

        @Override
        public void update() {
            this.update(this.parent.getSettings());
        }

        @Override
        public void clear() {
            this.parent.clear();
        }
    }

    private static class MemoryStorageLayer
    implements StorageLayer {
        @Nonnull
        private Settings settings;

        private MemoryStorageLayer() {
        }

        @Override
        public boolean initialize() {
            this.settings = new Settings();
            return false;
        }

        @Override
        @Nonnull
        public Settings getSettings() {
            return this.settings;
        }

        @Override
        public void update(@Nonnull Settings newSettings) {
            this.settings = newSettings;
        }

        @Override
        public void update() {
        }

        @Override
        public void clear() {
            this.settings = new Settings();
        }
    }

    private static interface StorageLayer {
        public boolean initialize();

        public Settings getSettings();

        public void update(Settings var1);

        public void update();

        public void clear();
    }

    public static enum StorageStrategy {
        REMOTE;

    }
}

