/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.client.ui;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.HasWidgets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.cxf.management.web.browser.client.ui.BindStrategy;
import org.apache.cxf.management.web.browser.client.ui.Presenter;
import org.apache.cxf.management.web.browser.client.ui.View;

public abstract class BasePresenter
implements Presenter {
    @Nonnull
    protected final EventBus eventBus;
    @Nonnull
    private final View view;
    @Nonnull
    private final BindStrategy bindStrategy;
    @Nonnull
    private final List<HandlerRegistration> handlerRegistrations;

    public BasePresenter(@Nonnull EventBus eventBus, @Nonnull View view, @Nonnull BindStrategy bindStrategy) {
        this.eventBus = eventBus;
        this.view = view;
        this.bindStrategy = bindStrategy;
        this.handlerRegistrations = new ArrayList<HandlerRegistration>();
    }

    @Override
    public void go(HasWidgets container) {
        this.bindStrategy.bind(container, this.view);
    }

    @Override
    public void unbind() {
        this.bindStrategy.unbind(this.view);
        for (HandlerRegistration handlerRegistration : this.handlerRegistrations) {
            handlerRegistration.removeHandler();
        }
        this.handlerRegistrations.clear();
    }

    protected void registerHandler(@Nonnull HandlerRegistration handlerRegistration) {
        this.handlerRegistrations.add(handlerRegistration);
    }
}

