/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.context;

import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.client.cli.ExecutionConfigAccessor;
import org.apache.flink.client.cli.ProgramOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.PluginUtils;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.util.FlinkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContext {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultContext.class);
    private final List<URL> dependencies;
    private final Configuration flinkConfig;

    public DefaultContext(List<URL> dependencies, Configuration flinkConfig, List<CustomCommandLine> commandLines) {
        this.dependencies = dependencies;
        this.flinkConfig = flinkConfig;
        Options commandLineOptions = this.collectCommandLineOptions(commandLines);
        FileSystem.initialize((Configuration)flinkConfig, (PluginManager)PluginUtils.createPluginManagerFromRootFolder((Configuration)flinkConfig));
        try {
            CommandLine deploymentCommandLine = CliFrontendParser.parse((Options)commandLineOptions, (String[])new String[0], (boolean)true);
            flinkConfig.addAll(DefaultContext.createExecutionConfig(deploymentCommandLine, commandLineOptions, commandLines, dependencies));
        }
        catch (Exception e) {
            throw new SqlExecutionException("Could not load available CLI.", e);
        }
    }

    public Configuration getFlinkConfig() {
        return this.flinkConfig;
    }

    public List<URL> getDependencies() {
        return this.dependencies;
    }

    private Options collectCommandLineOptions(List<CustomCommandLine> commandLines) {
        Options customOptions = new Options();
        for (CustomCommandLine customCommandLine : commandLines) {
            customCommandLine.addGeneralOptions(customOptions);
            customCommandLine.addRunOptions(customOptions);
        }
        return CliFrontendParser.mergeOptions((Options)CliFrontendParser.getRunCommandOptions(), (Options)customOptions);
    }

    private static Configuration createExecutionConfig(CommandLine commandLine, Options commandLineOptions, List<CustomCommandLine> availableCommandLines, List<URL> dependencies) throws FlinkException {
        LOG.debug("Available commandline options: {}", (Object)commandLineOptions);
        List options = Stream.of(commandLine.getOptions()).map(o -> o.getOpt() + "=" + o.getValue()).collect(Collectors.toList());
        LOG.debug("Instantiated commandline args: {}, options: {}", (Object)commandLine.getArgList(), options);
        CustomCommandLine activeCommandLine = DefaultContext.findActiveCommandLine(availableCommandLines, commandLine);
        LOG.debug("Available commandlines: {}, active commandline: {}", availableCommandLines, (Object)activeCommandLine);
        Configuration executionConfig = activeCommandLine.toConfiguration(commandLine);
        try {
            ProgramOptions programOptions = ProgramOptions.create((CommandLine)commandLine);
            ExecutionConfigAccessor executionConfigAccessor = ExecutionConfigAccessor.fromProgramOptions((ProgramOptions)programOptions, dependencies);
            executionConfigAccessor.applyToConfiguration(executionConfig);
        }
        catch (CliArgsException e) {
            throw new SqlExecutionException("Invalid deployment run options.", e);
        }
        LOG.info("Executor config: {}", (Object)executionConfig);
        return executionConfig;
    }

    private static CustomCommandLine findActiveCommandLine(List<CustomCommandLine> availableCommandLines, CommandLine commandLine) {
        for (CustomCommandLine cli : availableCommandLines) {
            if (!cli.isActive(commandLine)) continue;
            return cli;
        }
        throw new SqlExecutionException("Could not find a matching deployment.");
    }
}

