/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.context;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.client.ClientUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.context.DefaultContext;
import org.apache.flink.table.client.gateway.context.ExecutionContext;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.util.JarUtils;
import org.apache.flink.util.TemporaryClassLoaderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionContext {
    private static final Logger LOG = LoggerFactory.getLogger(SessionContext.class);
    private final String sessionId;
    private final DefaultContext defaultContext;
    private final Configuration sessionConfiguration;
    private final SessionState sessionState;
    private Set<URL> dependencies;
    private URLClassLoader classLoader;
    private ExecutionContext executionContext;

    private SessionContext(DefaultContext defaultContext, String sessionId, Configuration sessionConfiguration, URLClassLoader classLoader, SessionState sessionState, ExecutionContext executionContext) {
        this.defaultContext = defaultContext;
        this.sessionId = sessionId;
        this.sessionConfiguration = sessionConfiguration;
        this.classLoader = classLoader;
        this.sessionState = sessionState;
        this.executionContext = executionContext;
        this.dependencies = new HashSet<URL>(defaultContext.getDependencies());
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public ReadableConfig getReadableConfig() {
        return this.sessionConfiguration;
    }

    public Map<String, String> getConfigMap() {
        return this.sessionConfiguration.toMap();
    }

    @VisibleForTesting
    Set<URL> getDependencies() {
        return this.dependencies;
    }

    public void reset() {
        this.resetSessionConfigurationToDefault(this.defaultContext.getFlinkConfig());
        this.updateClassLoaderAndDependencies(this.dependencies);
        this.executionContext = new ExecutionContext(this.sessionConfiguration, this.classLoader, this.sessionState);
    }

    public void reset(String key) {
        Configuration configuration = this.defaultContext.getFlinkConfig();
        if (configuration.containsKey(key)) {
            String defaultValue = (String)configuration.get(ConfigOptions.key((String)key).stringType().noDefaultValue());
            this.set(key, defaultValue);
        } else {
            ConfigOption keyToDelete = ConfigOptions.key((String)key).stringType().noDefaultValue();
            this.sessionConfiguration.removeConfig(keyToDelete);
            this.executionContext = new ExecutionContext(this.executionContext);
        }
    }

    public void set(String key, String value) {
        Configuration originConfiguration = this.sessionConfiguration.clone();
        this.sessionConfiguration.setString(key, value);
        try {
            ExecutionContext newContext;
            this.executionContext = newContext = new ExecutionContext(this.executionContext);
        }
        catch (Exception e) {
            this.resetSessionConfigurationToDefault(originConfiguration);
            throw new SqlExecutionException(String.format("Failed to set key %s with value %s.", key, value), e);
        }
    }

    public void close() {
        try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of((ClassLoader)this.classLoader);){
            for (String name : this.sessionState.catalogManager.listCatalogs()) {
                this.sessionState.catalogManager.getCatalog(name).ifPresent(Catalog::close);
            }
        }
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            LOG.debug("Error while closing class loader.", (Throwable)e);
        }
    }

    public static SessionContext create(DefaultContext defaultContext, String sessionId) {
        Configuration configuration = defaultContext.getFlinkConfig().clone();
        URLClassLoader classLoader = ClientUtils.buildUserCodeClassLoader(defaultContext.getDependencies(), Collections.emptyList(), (ClassLoader)SessionContext.class.getClassLoader(), (Configuration)configuration);
        ModuleManager moduleManager = new ModuleManager();
        EnvironmentSettings settings = EnvironmentSettings.newInstance().withConfiguration(configuration).build();
        CatalogManager catalogManager = CatalogManager.newBuilder().classLoader((ClassLoader)classLoader).config((ReadableConfig)configuration).defaultCatalog(settings.getBuiltInCatalogName(), (Catalog)new GenericInMemoryCatalog(settings.getBuiltInCatalogName(), settings.getBuiltInDatabaseName())).build();
        FunctionCatalog functionCatalog = new FunctionCatalog((ReadableConfig)configuration, catalogManager, moduleManager);
        SessionState sessionState = new SessionState(catalogManager, moduleManager, functionCatalog);
        ExecutionContext executionContext = new ExecutionContext(configuration, classLoader, sessionState);
        return new SessionContext(defaultContext, sessionId, configuration, classLoader, sessionState, executionContext);
    }

    public void addJar(String jarPath) {
        URL jarURL = this.getURLFromPath(jarPath, "SQL Client only supports to add local jars.");
        if (this.dependencies.contains(jarURL)) {
            return;
        }
        HashSet<URL> newDependencies = new HashSet<URL>(this.dependencies);
        Set<URL> jarsInConfig = this.getJarsInConfig();
        newDependencies.addAll(jarsInConfig);
        newDependencies.add(jarURL);
        this.updateClassLoaderAndDependencies(newDependencies);
        this.executionContext = new ExecutionContext(this.sessionConfiguration, this.classLoader, this.sessionState);
    }

    public void removeJar(String jarPath) {
        URL jarURL = this.getURLFromPath(jarPath, "SQL Client only supports to remove local jars.");
        if (!this.dependencies.contains(jarURL)) {
            LOG.warn(String.format("Could not remove the specified jar because the jar path(%s) is not found in session classloader.", jarPath));
            return;
        }
        HashSet<URL> newDependencies = new HashSet<URL>(this.dependencies);
        Set<URL> jarsInConfig = this.getJarsInConfig();
        newDependencies.addAll(jarsInConfig);
        newDependencies.remove(jarURL);
        this.updateClassLoaderAndDependencies(newDependencies);
        this.executionContext = new ExecutionContext(this.sessionConfiguration, this.classLoader, this.sessionState);
    }

    public List<String> listJars() {
        return this.dependencies.stream().map(URL::getPath).collect(Collectors.toList());
    }

    private void resetSessionConfigurationToDefault(Configuration defaultConf) {
        for (String key : this.sessionConfiguration.toMap().keySet()) {
            ConfigOption keyToDelete = ConfigOptions.key((String)key).stringType().noDefaultValue();
            this.sessionConfiguration.removeConfig(keyToDelete);
        }
        this.sessionConfiguration.addAll(defaultConf);
    }

    private void updateClassLoaderAndDependencies(Collection<URL> newDependencies) {
        ConfigUtils.encodeCollectionToConfig((WritableConfig)this.sessionConfiguration, (ConfigOption)PipelineOptions.JARS, new ArrayList<URL>(newDependencies), URL::toString);
        this.classLoader = ClientUtils.buildUserCodeClassLoader(new ArrayList<URL>(newDependencies), Collections.emptyList(), (ClassLoader)SessionContext.class.getClassLoader(), (Configuration)this.sessionConfiguration);
        this.dependencies = new HashSet<URL>(newDependencies);
    }

    private URL getURLFromPath(String jarPath, String message) {
        Path path = new Path(jarPath);
        String scheme = path.toUri().getScheme();
        if (scheme != null && !scheme.equals("file")) {
            throw new SqlExecutionException(message);
        }
        Path qualifiedPath = path.makeQualified(FileSystem.getLocalFileSystem());
        try {
            URL jarURL = qualifiedPath.toUri().toURL();
            JarUtils.checkJarFile((URL)jarURL);
            return jarURL;
        }
        catch (MalformedURLException e) {
            throw new SqlExecutionException(String.format("Failed to parse the input jar path: %s", jarPath), e);
        }
        catch (IOException e) {
            throw new SqlExecutionException(String.format("Failed to get the jar file with specified path: %s", jarPath), e);
        }
    }

    private Set<URL> getJarsInConfig() {
        HashSet<URL> jarsInConfig;
        try {
            jarsInConfig = new HashSet<URL>(ConfigUtils.decodeListFromConfig((ReadableConfig)this.sessionConfiguration, (ConfigOption)PipelineOptions.JARS, URL::new));
        }
        catch (MalformedURLException e) {
            throw new SqlExecutionException("Failed to parse the option `pipeline.jars` in configuration.", e);
        }
        return jarsInConfig;
    }

    public static class SessionState {
        public final CatalogManager catalogManager;
        public final FunctionCatalog functionCatalog;
        public final ModuleManager moduleManager;

        public SessionState(CatalogManager catalogManager, ModuleManager moduleManager, FunctionCatalog functionCatalog) {
            this.catalogManager = catalogManager;
            this.moduleManager = moduleManager;
            this.functionCatalog = functionCatalog;
        }
    }
}

