/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local.result;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.client.gateway.local.result.DynamicResult;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.CloseableIterator;

public abstract class CollectResultBase
implements DynamicResult {
    private final CloseableIterator<RowData> result;
    protected final Object resultLock;
    protected AtomicReference<SqlExecutionException> executionException = new AtomicReference();
    protected final ResultRetrievalThread retrievalThread;

    public CollectResultBase(TableResultInternal tableResult) {
        this.result = tableResult.collectInternal();
        this.resultLock = new Object();
        this.retrievalThread = new ResultRetrievalThread();
    }

    @Override
    public void close() throws Exception {
        this.retrievalThread.isRunning = false;
        this.retrievalThread.interrupt();
        this.result.close();
    }

    protected <T> TypedResult<T> handleMissingResult() {
        if (this.executionException.get() != null) {
            throw this.executionException.get();
        }
        return TypedResult.endOfStream();
    }

    protected abstract void processRecord(RowData var1);

    protected boolean isRetrieving() {
        return this.retrievalThread.isRunning;
    }

    protected class ResultRetrievalThread
    extends Thread {
        public volatile boolean isRunning = true;

        protected ResultRetrievalThread() {
        }

        @Override
        public void run() {
            try {
                while (this.isRunning && CollectResultBase.this.result.hasNext()) {
                    CollectResultBase.this.processRecord((RowData)CollectResultBase.this.result.next());
                }
            }
            catch (RuntimeException e) {
                CollectResultBase.this.executionException.compareAndSet(null, new SqlExecutionException("Error while retrieving result.", e));
            }
            this.isRunning = false;
        }
    }
}

