/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local.result;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.client.gateway.local.result.CollectResultBase;
import org.apache.flink.table.client.gateway.local.result.MaterializedResult;
import org.apache.flink.table.data.RowData;

public abstract class MaterializedCollectResultBase
extends CollectResultBase
implements MaterializedResult {
    public static final int MATERIALIZED_TABLE_MAX_INITIAL_CAPACITY = 1000000;
    public static final int MATERIALIZED_TABLE_MAX_OVERCOMMIT = 1000000;
    public static final double MATERIALIZED_TABLE_CAPACITY_FACTOR = 0.05;
    public static final double MATERIALIZED_TABLE_OVERCOMMIT_FACTOR = 0.01;
    protected final int maxRowCount;
    protected final int overcommitThreshold;
    protected final List<RowData> materializedTable;
    protected int validRowPosition;
    private final List<RowData> snapshot;
    private int pageCount;
    private int pageSize;
    private boolean isLastSnapshot;

    public MaterializedCollectResultBase(TableResultInternal tableResult, int maxRowCount, int overcommitThreshold) {
        super(tableResult);
        this.maxRowCount = maxRowCount <= 0 ? Integer.MAX_VALUE : maxRowCount;
        this.overcommitThreshold = overcommitThreshold;
        int initialCapacity = MaterializedCollectResultBase.computeMaterializedTableCapacity(maxRowCount);
        this.materializedTable = new ArrayList<RowData>(initialCapacity);
        this.validRowPosition = 0;
        this.snapshot = new ArrayList<RowData>();
        this.isLastSnapshot = false;
        this.pageCount = 0;
    }

    @Override
    public final boolean isMaterialized() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedResult<Integer> snapshot(int pageSize) {
        if (pageSize < 1) {
            throw new SqlExecutionException("Page size must be greater than 0.");
        }
        Object object = this.resultLock;
        synchronized (object) {
            if (!this.isRetrieving() && this.isLastSnapshot || this.executionException.get() != null) {
                return this.handleMissingResult();
            }
            if (!this.isRetrieving()) {
                this.isLastSnapshot = true;
            }
            this.pageSize = pageSize;
            this.snapshot.clear();
            for (int i = this.validRowPosition; i < this.materializedTable.size(); ++i) {
                this.snapshot.add(this.materializedTable.get(i));
            }
            this.pageCount = Math.max(1, (int)Math.ceil((double)this.snapshot.size() / (double)pageSize));
            return TypedResult.payload(this.pageCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RowData> retrievePage(int page) {
        Object object = this.resultLock;
        synchronized (object) {
            if (page <= 0 || page > this.pageCount) {
                throw new SqlExecutionException("Invalid page '" + page + "'.");
            }
            return this.snapshot.subList(this.pageSize * (page - 1), Math.min(this.snapshot.size(), this.pageSize * page));
        }
    }

    protected static int computeMaterializedTableCapacity(int maxRowCount) {
        return Math.min(1000000, Math.max(1, (int)((double)maxRowCount * 0.05)));
    }

    protected static int computeMaterializedTableOvercommit(int maxRowCount) {
        return Math.min(1000000, (int)((double)maxRowCount * 0.01));
    }

    @VisibleForTesting
    protected List<RowData> getMaterializedTable() {
        return this.materializedTable;
    }
}

