/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver.rules;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.resolver.rules.ResolverRule;
import org.apache.flink.table.expressions.resolver.rules.RuleExpressionVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;

@Internal
final class QualifyBuiltInFunctionsRule
implements ResolverRule {
    QualifyBuiltInFunctionsRule() {
    }

    @Override
    public List<Expression> apply(List<Expression> expression, ResolverRule.ResolutionContext context) {
        return expression.stream().map(expr -> (Expression)expr.accept((ExpressionVisitor)new QualifyBuiltInFunctionVisitor(context))).collect(Collectors.toList());
    }

    private static class QualifyBuiltInFunctionVisitor
    extends RuleExpressionVisitor<Expression> {
        QualifyBuiltInFunctionVisitor(ResolverRule.ResolutionContext resolutionContext) {
            super(resolutionContext);
        }

        @Override
        public Expression visit(UnresolvedCallExpression unresolvedCall) {
            FunctionIdentifier identifier;
            FunctionDefinition definition = unresolvedCall.getFunctionDefinition();
            if (!unresolvedCall.getFunctionIdentifier().isPresent() && definition instanceof BuiltInFunctionDefinition) {
                FunctionLookup.Result functionLookup = this.resolutionContext.functionLookup().lookupBuiltInFunction((BuiltInFunctionDefinition)unresolvedCall.getFunctionDefinition());
                identifier = functionLookup.getFunctionIdentifier();
            } else {
                identifier = unresolvedCall.getFunctionIdentifier().orElse(null);
            }
            return ApiExpressionUtils.unresolvedCall(identifier, definition, unresolvedCall.getChildren().stream().map(c -> (Expression)c.accept((ExpressionVisitor)this)).collect(Collectors.toList()));
        }

        @Override
        protected Expression defaultMethod(Expression expression) {
            return expression;
        }
    }
}

