/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.SetQueryOperation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
final class SetOperationFactory {
    private final boolean isStreamingMode;

    public SetOperationFactory(boolean isStreamingMode) {
        this.isStreamingMode = isStreamingMode;
    }

    QueryOperation create(SetQueryOperation.SetQueryOperationType type, QueryOperation left, QueryOperation right, boolean all) {
        this.failIfStreaming(type, all);
        this.validateSetOperation(type, left, right);
        return new SetQueryOperation(left, right, type, all, this.createCommonTableSchema(left, right));
    }

    private void validateSetOperation(SetQueryOperation.SetQueryOperationType operationType, QueryOperation left, QueryOperation right) {
        ResolvedSchema rightSchema;
        int rightFieldCount;
        ResolvedSchema leftSchema = left.getResolvedSchema();
        int leftFieldCount = leftSchema.getColumnCount();
        if (leftFieldCount != (rightFieldCount = (rightSchema = right.getResolvedSchema()).getColumnCount())) {
            throw new ValidationException(String.format("The %s operation on two tables of different column sizes: %d and %d is not supported", operationType.toString().toLowerCase(), leftFieldCount, rightFieldCount));
        }
        List leftDataTypes = leftSchema.getColumnDataTypes();
        List rightDataTypes = rightSchema.getColumnDataTypes();
        IntStream.range(0, leftFieldCount).forEach(idx -> {
            if (!this.findCommonColumnType(leftDataTypes, rightDataTypes, idx).isPresent()) {
                throw new ValidationException(String.format("Incompatible types for %s operation. Could not find a common type at position %s for '%s' and '%s'.", operationType.toString().toLowerCase(), idx, leftDataTypes.get(idx), rightDataTypes.get(idx)));
            }
        });
    }

    private void failIfStreaming(SetQueryOperation.SetQueryOperationType type, boolean all) {
        boolean shouldFailInCaseOfStreaming;
        boolean bl = shouldFailInCaseOfStreaming = !all || type != SetQueryOperation.SetQueryOperationType.UNION;
        if (this.isStreamingMode && shouldFailInCaseOfStreaming) {
            throw new ValidationException(String.format("The %s operation on two unbounded tables is currently not supported.", new Object[]{type}));
        }
    }

    private ResolvedSchema createCommonTableSchema(QueryOperation left, QueryOperation right) {
        ResolvedSchema leftSchema = left.getResolvedSchema();
        List leftDataTypes = leftSchema.getColumnDataTypes();
        List rightDataTypes = right.getResolvedSchema().getColumnDataTypes();
        List resultDataTypes = IntStream.range(0, leftSchema.getColumnCount()).mapToObj(idx -> this.findCommonColumnType(leftDataTypes, rightDataTypes, idx).orElseThrow(AssertionError::new)).map(TypeConversions::fromLogicalToDataType).collect(Collectors.toList());
        return ResolvedSchema.physical((List)leftSchema.getColumnNames(), resultDataTypes);
    }

    private Optional<LogicalType> findCommonColumnType(List<DataType> leftDataTypes, List<DataType> rightDataTypes, int idx) {
        LogicalType leftType = leftDataTypes.get(idx).getLogicalType();
        LogicalType rightType = rightDataTypes.get(idx).getLogicalType();
        return LogicalTypeMerging.findCommonType(Arrays.asList(leftType, rightType));
    }
}

