/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cli.deployer;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.geronimo.cli.CLParserException;
import org.apache.geronimo.cli.deployer.ListModulesCommandArgs;

public class ListModulesCommandArgsImpl
implements ListModulesCommandArgs {
    private static final String ARGUMENT_ALL_SHORTFORM = "a";
    private static final String ARGUMENT_ALL = "all";
    private static final String ARGUMENT_STARTED_SHORTFORM = "s";
    private static final String ARGUMENT_STARTED = "started";
    private static final String ARGUMENT_STOPPED_SHORTFORM = "t";
    private static final String ARGUMENT_STOPPED = "stopped";
    protected final Options options = new Options();
    protected CommandLine commandLine;

    public ListModulesCommandArgsImpl(String[] args) throws CLParserException {
        this.addState();
        GnuParser parser = new GnuParser();
        try {
            this.commandLine = parser.parse(this.options, args, true);
        }
        catch (ParseException e) {
            throw new CLParserException(e.getMessage(), e);
        }
    }

    public boolean isAll() {
        return this.commandLine.hasOption(ARGUMENT_ALL_SHORTFORM);
    }

    public boolean isStarted() {
        return this.commandLine.hasOption(ARGUMENT_STARTED_SHORTFORM);
    }

    public boolean isStopped() {
        return this.commandLine.hasOption(ARGUMENT_STOPPED_SHORTFORM);
    }

    public String[] getArgs() {
        return this.commandLine.getArgs();
    }

    protected void addState() {
        OptionGroup optionGroup = new OptionGroup();
        Option option = new Option(ARGUMENT_ALL_SHORTFORM, ARGUMENT_ALL, false, "All modules will be listed.");
        optionGroup.addOption(option);
        option = new Option(ARGUMENT_STARTED_SHORTFORM, ARGUMENT_STARTED, false, "Only started modules will be listed.");
        optionGroup.addOption(option);
        option = new Option(ARGUMENT_STOPPED_SHORTFORM, ARGUMENT_STOPPED, false, "Only stopped modules will be listed.");
        optionGroup.addOption(option);
        this.options.addOptionGroup(optionGroup);
    }
}

