/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.util.asn1.x509;

import org.apache.geronimo.util.asn1.ASN1Choice;
import org.apache.geronimo.util.asn1.ASN1Encodable;
import org.apache.geronimo.util.asn1.ASN1Set;
import org.apache.geronimo.util.asn1.ASN1TaggedObject;
import org.apache.geronimo.util.asn1.DEREncodable;
import org.apache.geronimo.util.asn1.DERObject;
import org.apache.geronimo.util.asn1.DERTaggedObject;
import org.apache.geronimo.util.asn1.x509.GeneralNames;

public class DistributionPointName
extends ASN1Encodable
implements ASN1Choice {
    DEREncodable name;
    int type;
    public static final int FULL_NAME = 0;
    public static final int NAME_RELATIVE_TO_CRL_ISSUER = 1;

    public static DistributionPointName getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DistributionPointName.getInstance(ASN1TaggedObject.getInstance(obj, true));
    }

    public static DistributionPointName getInstance(Object obj) {
        if (obj == null || obj instanceof DistributionPointName) {
            return (DistributionPointName)obj;
        }
        if (obj instanceof ASN1TaggedObject) {
            return new DistributionPointName((ASN1TaggedObject)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public DistributionPointName(int type, DEREncodable name) {
        this.type = type;
        this.name = name;
    }

    public DistributionPointName(int type, ASN1Encodable name) {
        this.type = type;
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public ASN1Encodable getName() {
        return (ASN1Encodable)this.name;
    }

    public DistributionPointName(ASN1TaggedObject obj) {
        this.type = obj.getTagNo();
        this.name = this.type == 0 ? GeneralNames.getInstance(obj, false) : ASN1Set.getInstance(obj, false);
    }

    public DERObject toASN1Object() {
        return new DERTaggedObject(false, this.type, this.name);
    }
}

