/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.util.HashMap;
import java.util.Map;

public enum AbfsStatistic {
    CALL_CREATE("op_create", "Calls of create()."),
    CALL_OPEN("op_open", "Calls of open()."),
    CALL_GET_FILE_STATUS("op_get_file_status", "Calls of getFileStatus()."),
    CALL_APPEND("op_append", "Calls of append()."),
    CALL_CREATE_NON_RECURSIVE("op_create_non_recursive", "Calls of createNonRecursive()."),
    CALL_DELETE("op_delete", "Calls of delete()."),
    CALL_EXIST("op_exists", "Calls of exist()."),
    CALL_GET_DELEGATION_TOKEN("op_get_delegation_token", "Calls of getDelegationToken()."),
    CALL_LIST_STATUS("op_list_status", "Calls of listStatus()."),
    CALL_MKDIRS("op_mkdirs", "Calls of mkdirs()."),
    CALL_RENAME("op_rename", "Calls of rename()."),
    DIRECTORIES_CREATED("directories_created", "Total number of directories created through the object store."),
    DIRECTORIES_DELETED("directories_deleted", "Total number of directories deleted through the object store."),
    FILES_CREATED("files_created", "Total number of files created through the object store."),
    FILES_DELETED("files_deleted", "Total number of files deleted from the object store."),
    ERROR_IGNORED("error_ignored", "Errors caught and ignored."),
    CONNECTIONS_MADE("connections_made", "Total number of times a connection was made with the data store."),
    SEND_REQUESTS("send_requests", "Total number of times http requests were sent to the data store."),
    GET_RESPONSES("get_responses", "Total number of times a response was received."),
    BYTES_SENT("bytes_sent", "Total bytes uploaded."),
    BYTES_RECEIVED("bytes_received", "Total bytes received."),
    READ_THROTTLES("read_throttles", "Total number of times a read operation is throttled."),
    WRITE_THROTTLES("write_throttles", "Total number of times a write operation is throttled."),
    SERVER_UNAVAILABLE("server_unavailable", "Total number of times HTTP 503 status code is received in response."),
    HTTP_HEAD_REQUEST("action_http_head_request", "Time taken to complete a HEAD request", "HEAD"),
    HTTP_GET_REQUEST("action_http_get_request", "Time taken to complete a GET request", "GET"),
    HTTP_DELETE_REQUEST("action_http_delete_request", "Time taken to complete a DELETE request", "DELETE"),
    HTTP_PUT_REQUEST("action_http_put_request", "Time taken to complete a PUT request", "PUT"),
    HTTP_PATCH_REQUEST("action_http_patch_request", "Time taken to complete a PATCH request", "PATCH"),
    HTTP_POST_REQUEST("action_http_post_request", "Time taken to complete a POST request", "POST"),
    RENAME_RECOVERY("rename_recovery", "Number of times Rename recoveries happened"),
    METADATA_INCOMPLETE_RENAME_FAILURES("metadata_incomplete_rename_failures", "Number of times rename operation failed due to metadata being incomplete"),
    RENAME_PATH_ATTEMPTS("rename_path_attempts", "Number of times we attempt to rename a path internally");

    private String statName;
    private String statDescription;
    private String httpCall;
    private static final Map<String, String> HTTP_CALL_TO_NAME_MAP;

    private AbfsStatistic(String statName, String statDescription) {
        this.statName = statName;
        this.statDescription = statDescription;
    }

    private AbfsStatistic(String statName, String statDescription, String httpCall) {
        this.statName = statName;
        this.statDescription = statDescription;
        this.httpCall = httpCall;
    }

    public String getStatName() {
        return this.statName;
    }

    public String getStatDescription() {
        return this.statDescription;
    }

    public String getHttpCall() {
        return this.httpCall;
    }

    public static String getStatNameFromHttpCall(String httpCall) {
        return HTTP_CALL_TO_NAME_MAP.get(httpCall);
    }

    static {
        HTTP_CALL_TO_NAME_MAP = new HashMap<String, String>();
        for (AbfsStatistic statistic : AbfsStatistic.values()) {
            if (statistic.getHttpCall() == null) continue;
            HTTP_CALL_TO_NAME_MAP.put(statistic.getHttpCall(), statistic.getStatName());
        }
    }
}

