/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.consensus;

import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.consensus.ConsensusFactory;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.config.MultiLeaderConfig;
import org.apache.iotdb.consensus.config.RatisConfig;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.statemachine.DataRegionStateMachine;
import org.apache.iotdb.db.engine.StorageEngineV2;

public class DataRegionConsensusImpl {
    private static final IoTDBConfig conf = IoTDBDescriptor.getInstance().getConfig();
    private static IConsensus INSTANCE = null;

    private DataRegionConsensusImpl() {
    }

    public static IConsensus getInstance() {
        return INSTANCE;
    }

    public static synchronized IConsensus setupAndGetInstance() {
        if (INSTANCE == null) {
            INSTANCE = (IConsensus)ConsensusFactory.getConsensusImpl((String)conf.getDataRegionConsensusProtocolClass(), (ConsensusConfig)ConsensusConfig.newBuilder().setThisNode(new TEndPoint(conf.getInternalIp(), conf.getDataRegionConsensusPort())).setStorageDir(conf.getDataRegionConsensusDir()).setMultiLeaderConfig(MultiLeaderConfig.newBuilder().setRpc(MultiLeaderConfig.RPC.newBuilder().setConnectionTimeoutInMs(conf.getConnectionTimeoutInMS()).setRpcMaxConcurrentClientNum(conf.getRpcMaxConcurrentClientNum()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnable()).setSelectorNumOfClientManager(conf.getSelectorNumOfClientManager()).setThriftServerAwaitTimeForStopService(conf.getThriftServerAwaitTimeForStopService()).build()).build()).setRatisConfig(RatisConfig.newBuilder().setSnapshot(RatisConfig.Snapshot.newBuilder().setCreationGap(1L).build()).build()).build(), gid -> new DataRegionStateMachine(StorageEngineV2.getInstance().getDataRegion((DataRegionId)gid))).orElseThrow(() -> new IllegalArgumentException(String.format("Construct consensusImpl failed, Please check your consensus className %s", conf.getDataRegionConsensusProtocolClass())));
        }
        return INSTANCE;
    }
}

