/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.constant.CrossCompactionSelector;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.CrossSpaceCompactionResource;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.selector.ICrossSpaceMergeFileSelector;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.selector.RewriteCompactionFileSelector;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private static final int subTaskNum = IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum();

    public static void moveTargetFile(List<TsFileResource> targetResources, boolean isInnerSpace, String fullStorageGroupName) throws IOException, WriteProcessException {
        String fileSuffix = isInnerSpace ? ".inner" : ".cross";
        for (TsFileResource targetResource : targetResources) {
            CompactionUtils.moveOneTargetFile(targetResource, fileSuffix, fullStorageGroupName);
        }
    }

    private static void moveOneTargetFile(TsFileResource targetResource, String tmpFileSuffix, String fullStorageGroupName) throws IOException {
        if (!targetResource.getTsFile().exists()) {
            logger.info("{} [Compaction] Tmp target tsfile {} may be deleted after compaction.", (Object)fullStorageGroupName, (Object)targetResource.getTsFilePath());
            return;
        }
        File newFile = new File(targetResource.getTsFilePath().replace(tmpFileSuffix, ".tsfile"));
        if (!newFile.exists()) {
            FSFactoryProducer.getFSFactory().moveFile(targetResource.getTsFile(), newFile);
        }
        targetResource.setFile(newFile);
        targetResource.serialize();
        targetResource.close();
    }

    public static void combineModsInCrossCompaction(List<TsFileResource> seqResources, List<TsFileResource> unseqResources, List<TsFileResource> targetResources) throws IOException {
        HashMap<String, TsFileResource> seqFileInfoMap = new HashMap<String, TsFileResource>();
        for (TsFileResource tsFileResource : seqResources) {
            seqFileInfoMap.put(TsFileNameGenerator.increaseCrossCompactionCnt(tsFileResource.getTsFile()).getName(), tsFileResource);
        }
        for (TsFileResource tsFileResource : targetResources) {
            CompactionUtils.updateOneTargetMods(tsFileResource, (TsFileResource)seqFileInfoMap.get(tsFileResource.getTsFile().getName()), unseqResources);
        }
    }

    public static void combineModsInInnerCompaction(Collection<TsFileResource> sourceFiles, TsFileResource targetTsFile) throws IOException {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        for (TsFileResource mergeTsFile : sourceFiles) {
            ModificationFile sourceCompactionModificationFile = ModificationFile.getCompactionMods(mergeTsFile);
            Throwable throwable = null;
            try {
                modifications.addAll(sourceCompactionModificationFile.getModifications());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (sourceCompactionModificationFile == null) continue;
                if (throwable != null) {
                    try {
                        sourceCompactionModificationFile.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                sourceCompactionModificationFile.close();
            }
        }
        if (!modifications.isEmpty()) {
            try (ModificationFile modificationFile = ModificationFile.getNormalMods(targetTsFile);){
                for (Modification modification : modifications) {
                    modification.setFileOffset(Long.MAX_VALUE);
                    modificationFile.write(modification);
                }
            }
        }
    }

    private static void updateOneTargetMods(TsFileResource targetFile, TsFileResource seqFile, List<TsFileResource> unseqFiles) throws IOException {
        if (seqFile != null) {
            ModificationFile seqCompactionModificationFile = ModificationFile.getCompactionMods(seqFile);
            for (Modification modification : seqCompactionModificationFile.getModifications()) {
                targetFile.getModFile().write(modification);
            }
        }
        for (TsFileResource unseqFile : unseqFiles) {
            ModificationFile compactionUnseqModificationFile = ModificationFile.getCompactionMods(unseqFile);
            for (Modification modification : compactionUnseqModificationFile.getModifications()) {
                targetFile.getModFile().write(modification);
            }
        }
        targetFile.getModFile().close();
    }

    public static void deleteCompactionModsFile(List<TsFileResource> selectedSeqTsFileResourceList, List<TsFileResource> selectedUnSeqTsFileResourceList) throws IOException {
        ModificationFile modificationFile;
        for (TsFileResource seqFile : selectedSeqTsFileResourceList) {
            modificationFile = seqFile.getCompactionModFile();
            if (!modificationFile.exists()) continue;
            modificationFile.remove();
        }
        for (TsFileResource unseqFile : selectedUnSeqTsFileResourceList) {
            modificationFile = unseqFile.getCompactionModFile();
            if (!modificationFile.exists()) continue;
            modificationFile.remove();
        }
    }

    public static boolean deleteTsFilesInDisk(Collection<TsFileResource> mergeTsFiles, String storageGroupName) {
        logger.info("{} [Compaction] Compaction starts to delete real file ", (Object)storageGroupName);
        boolean result = true;
        for (TsFileResource mergeTsFile : mergeTsFiles) {
            if (!CompactionUtils.deleteTsFile(mergeTsFile)) {
                result = false;
            }
            logger.info("{} [Compaction] delete TsFile {}", (Object)storageGroupName, (Object)mergeTsFile.getTsFilePath());
        }
        return result;
    }

    public static boolean deleteTsFile(TsFileResource seqFile) {
        try {
            FileReaderManager.getInstance().closeFileAndRemoveReader(seqFile.getTsFilePath());
            seqFile.setStatus(TsFileResourceStatus.DELETED);
            seqFile.delete();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public static void deleteModificationForSourceFile(Collection<TsFileResource> sourceFiles, String storageGroupName) throws IOException {
        logger.info("{} [Compaction] Start to delete modifications of source files", (Object)storageGroupName);
        for (TsFileResource tsFileResource : sourceFiles) {
            ModificationFile normalModification;
            ModificationFile compactionModificationFile = ModificationFile.getCompactionMods(tsFileResource);
            if (compactionModificationFile.exists()) {
                compactionModificationFile.remove();
            }
            if (!(normalModification = ModificationFile.getNormalMods(tsFileResource)).exists()) continue;
            normalModification.remove();
        }
    }

    public static ICrossSpaceMergeFileSelector getCrossSpaceFileSelector(long budget, CrossSpaceCompactionResource resource) {
        CrossCompactionSelector strategy = IoTDBDescriptor.getInstance().getConfig().getCrossCompactionSelector();
        switch (strategy) {
            case REWRITE: {
                return new RewriteCompactionFileSelector(resource, budget);
            }
        }
        throw new UnsupportedOperationException("Unknown CrossSpaceFileStrategy " + (Object)((Object)strategy));
    }
}

