/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.rewrite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.cross.ICrossSpaceSelector;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.CrossSpaceCompactionResource;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.selector.ICrossSpaceMergeFileSelector;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.MergeException;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteCrossSpaceCompactionSelector
implements ICrossSpaceSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    protected String logicalStorageGroupName;
    protected String dataRegionId;
    protected long timePartition;
    protected TsFileManager tsFileManager;

    public RewriteCrossSpaceCompactionSelector(String logicalStorageGroupName, String dataRegionId, long timePartition, TsFileManager tsFileManager) {
        this.logicalStorageGroupName = logicalStorageGroupName;
        this.dataRegionId = dataRegionId;
        this.timePartition = timePartition;
        this.tsFileManager = tsFileManager;
    }

    public List selectCrossSpaceTask(List<TsFileResource> sequenceFileList, List<TsFileResource> unsequenceFileList) {
        if (CompactionTaskManager.currentTaskNum.get() >= config.getConcurrentCompactionThread() || !config.isEnableCrossSpaceCompaction()) {
            return Collections.emptyList();
        }
        Iterator<TsFileResource> seqIterator = sequenceFileList.iterator();
        Iterator<TsFileResource> unSeqIterator = unsequenceFileList.iterator();
        ArrayList<TsFileResource> seqFileList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unSeqFileList = new ArrayList<TsFileResource>();
        while (seqIterator.hasNext()) {
            seqFileList.add(seqIterator.next());
        }
        while (unSeqIterator.hasNext()) {
            unSeqFileList.add(unSeqIterator.next());
        }
        if (seqFileList.isEmpty() || unSeqFileList.isEmpty()) {
            return Collections.emptyList();
        }
        long budget = config.getCrossCompactionMemoryBudget();
        long timeLowerBound = System.currentTimeMillis() - Long.MAX_VALUE;
        CrossSpaceCompactionResource compactionResource = new CrossSpaceCompactionResource(seqFileList, unSeqFileList, timeLowerBound);
        ICrossSpaceMergeFileSelector fileSelector = CompactionUtils.getCrossSpaceFileSelector(budget, compactionResource);
        try {
            List[] mergeFiles = fileSelector.select();
            if (mergeFiles.length == 0) {
                if (compactionResource.getUnseqFiles().size() > 0) {
                    LOGGER.warn("{} cannot select merge candidates under the budget {}", (Object)this.logicalStorageGroupName, (Object)budget);
                }
                return Collections.emptyList();
            }
            LOGGER.info("select files for cross compaction, sequence files: {}, unsequence files {}", (Object)mergeFiles[0], (Object)mergeFiles[1]);
            if (mergeFiles[0].size() > 0 && mergeFiles[1].size() > 0) {
                LOGGER.info("{} [Compaction] submit a task with {} sequence file and {} unseq files", new Object[]{this.logicalStorageGroupName + "-" + this.dataRegionId, compactionResource.getSeqFiles().size(), compactionResource.getUnseqFiles().size()});
                return Collections.singletonList(new Pair((Object)mergeFiles[0], (Object)mergeFiles[1]));
            }
        }
        catch (MergeException e) {
            LOGGER.error("{} cannot select file for cross space compaction", (Object)this.logicalStorageGroupName, (Object)e);
        }
        return Collections.emptyList();
    }
}

