/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.logfile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLogTxtReader
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MLogTxtReader.class);
    private BufferedReader bufferedReader;
    private File logFile;
    private String cmd;

    public MLogTxtReader(String schemaDir, String logFileName) throws IOException {
        File metadataDir = SystemFileFactory.INSTANCE.getFile(schemaDir);
        if (!metadataDir.exists()) {
            logger.error("no mlog.txt to init SchemaRegion.");
            throw new IOException("mlog.txt does not exist.");
        }
        this.logFile = SystemFileFactory.INSTANCE.getFile(schemaDir + File.separator + logFileName);
        this.bufferedReader = new BufferedReader(new FileReader(this.logFile));
    }

    public String next() {
        String ret = this.cmd;
        this.cmd = null;
        return ret;
    }

    public boolean hasNext() {
        if (this.cmd != null) {
            return true;
        }
        try {
            this.cmd = this.bufferedReader.readLine();
            return this.cmd != null;
        }
        catch (IOException e) {
            logger.warn("Read mlog error.");
            this.cmd = null;
            return false;
        }
    }

    @Override
    public void close() {
        try {
            this.bufferedReader.close();
        }
        catch (IOException e) {
            logger.error("Failed to close mlog.txt");
        }
    }
}

