/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.schemafile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.metadata.schemafile.SchemaPageOverflowException;
import org.apache.iotdb.db.exception.metadata.schemafile.SegmentNotFoundException;
import org.apache.iotdb.db.metadata.mnode.IMNode;

public interface ISchemaPage {
    public long write(short var1, String var2, ByteBuffer var3) throws MetadataException;

    public IMNode read(short var1, String var2) throws SegmentNotFoundException;

    public void update(short var1, String var2, ByteBuffer var3) throws MetadataException;

    public boolean hasRecordKeyInSegment(String var1, short var2) throws SegmentNotFoundException;

    public Queue<IMNode> getChildren(short var1) throws SegmentNotFoundException;

    public void removeRecord(short var1, String var2) throws SegmentNotFoundException;

    public void deleteSegment(short var1) throws SegmentNotFoundException;

    public int getPageIndex();

    public short getSpareSize();

    public short getSegmentSize(short var1) throws SegmentNotFoundException;

    public void getPageBuffer(ByteBuffer var1);

    public boolean isCapableForSize(short var1);

    public boolean isSegmentCapableFor(short var1, short var2) throws SegmentNotFoundException;

    public void syncPageBuffer();

    public short allocNewSegment(short var1) throws IOException, SchemaPageOverflowException;

    public long transplantSegment(ISchemaPage var1, short var2, short var3) throws MetadataException;

    public void setNextSegAddress(short var1, long var2) throws SegmentNotFoundException;

    public void setPrevSegAddress(short var1, long var2) throws SegmentNotFoundException;

    public long getNextSegAddress(short var1) throws SegmentNotFoundException;

    public long getPrevSegAddress(short var1) throws SegmentNotFoundException;

    public String inspect() throws SegmentNotFoundException;
}

