/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.collector;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.CollectorTraverser;

public abstract class MNodeCollector<T>
extends CollectorTraverser<T> {
    protected LocalSchemaProcessor.StorageGroupFilter storageGroupFilter = null;
    protected int targetLevel = -1;
    private Set<IMNode> processedNodes = new HashSet<IMNode>();

    public MNodeCollector(IMNode startNode, PartialPath path, IMTreeStore store) throws MetadataException {
        super(startNode, path, store);
    }

    @Override
    protected void traverse(IMNode node, int idx, int level) throws MetadataException {
        if (this.storageGroupFilter != null && node.isStorageGroup() && !this.storageGroupFilter.satisfy(node.getFullPath())) {
            return;
        }
        super.traverse(node, idx, level);
    }

    @Override
    protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) {
        return false;
    }

    @Override
    protected boolean processFullMatchedMNode(IMNode node, int idx, int level) {
        if (this.targetLevel >= 0) {
            if (level < this.targetLevel) {
                return false;
            }
            ArrayDeque<IMNode> stack = new ArrayDeque<IMNode>();
            while (level > this.targetLevel) {
                node = (IMNode)this.traverseContext.pop();
                stack.push(node);
                --level;
            }
            if (!this.processedNodes.contains(node)) {
                this.processedNodes.add(node);
                this.transferToResult(node);
            }
            while (!stack.isEmpty()) {
                this.traverseContext.push(stack.pop());
            }
            return true;
        }
        this.transferToResult(node);
        return false;
    }

    protected abstract void transferToResult(IMNode var1);

    public void setStorageGroupFilter(LocalSchemaProcessor.StorageGroupFilter storageGroupFilter) {
        this.storageGroupFilter = storageGroupFilter;
    }

    public void setTargetLevel(int targetLevel) {
        this.targetLevel = targetLevel;
    }
}

