/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.schematree;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PathPatternNode {
    private final String name;
    private final Map<String, PathPatternNode> children;

    public PathPatternNode(String name) {
        this.name = name;
        this.children = new HashMap<String, PathPatternNode>();
    }

    public String getName() {
        return this.name;
    }

    public PathPatternNode getChildren(String nodeName) {
        return this.children.getOrDefault(nodeName, null);
    }

    public Map<String, PathPatternNode> getChildren() {
        return this.children;
    }

    public void addChild(PathPatternNode tmpNode) {
        this.children.put(tmpNode.getName(), tmpNode);
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean isWildcard() {
        return this.name.equals("*") || this.name.equals("**");
    }

    public boolean equalWith(PathPatternNode that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        if (!Objects.equals(that.getName(), this.getName())) {
            return false;
        }
        if (that.isLeaf() && this.isLeaf()) {
            return true;
        }
        if (that.getChildren().size() != this.getChildren().size()) {
            return false;
        }
        for (Map.Entry<String, PathPatternNode> entry : this.getChildren().entrySet()) {
            String nodeName = entry.getKey();
            if (that.getChildren(nodeName) != null && that.getChildren(nodeName).equalWith(this.getChildren(nodeName))) continue;
            return false;
        }
        return true;
    }

    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((String)this.name, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((int)this.children.size(), (ByteBuffer)buffer);
        this.serializeChildren(buffer);
    }

    void serializeChildren(ByteBuffer buffer) {
        for (PathPatternNode childNode : this.children.values()) {
            childNode.serialize(buffer);
        }
    }

    public void serialize(PublicBAOS outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.name, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.children.size(), (OutputStream)outputStream);
        this.serializeChildren(outputStream);
    }

    public void serialize(DataOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.name, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.children.size(), (OutputStream)outputStream);
        this.serializeChildren(outputStream);
    }

    void serializeChildren(PublicBAOS outputStream) throws IOException {
        for (PathPatternNode childNode : this.children.values()) {
            childNode.serialize(outputStream);
        }
    }

    void serializeChildren(DataOutputStream outputStream) throws IOException {
        for (PathPatternNode childNode : this.children.values()) {
            childNode.serialize(outputStream);
        }
    }
}

