/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.exchange;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.mpp.execution.exchange.LocalSinkHandle;
import org.apache.iotdb.db.mpp.execution.exchange.LocalSourceHandle;
import org.apache.iotdb.db.mpp.execution.memory.LocalMemoryManager;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SharedTsBlockQueue {
    private static final Logger logger = LoggerFactory.getLogger(SharedTsBlockQueue.class);
    private final TFragmentInstanceId localFragmentInstanceId;
    private final LocalMemoryManager localMemoryManager;
    private boolean noMoreTsBlocks = false;
    private long bufferRetainedSizeInBytes = 0L;
    private final Queue<TsBlock> queue = new LinkedList<TsBlock>();
    private SettableFuture<Void> blocked = SettableFuture.create();
    private ListenableFuture<Void> blockedOnMemory;
    private boolean destroyed = false;
    private LocalSourceHandle sourceHandle;
    private LocalSinkHandle sinkHandle;

    public SharedTsBlockQueue(TFragmentInstanceId fragmentInstanceId, LocalMemoryManager localMemoryManager) {
        this.localFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)fragmentInstanceId, (String)"fragment instance ID cannot be null", (Object[])new Object[0]);
        this.localMemoryManager = (LocalMemoryManager)Validate.notNull((Object)localMemoryManager, (String)"local memory manager cannot be null", (Object[])new Object[0]);
    }

    public boolean hasNoMoreTsBlocks() {
        return this.noMoreTsBlocks;
    }

    public long getBufferRetainedSizeInBytes() {
        return this.bufferRetainedSizeInBytes;
    }

    public ListenableFuture<Void> isBlocked() {
        return this.blocked;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void setSinkHandle(LocalSinkHandle sinkHandle) {
        this.sinkHandle = sinkHandle;
    }

    public void setSourceHandle(LocalSourceHandle sourceHandle) {
        this.sourceHandle = sourceHandle;
    }

    public void setNoMoreTsBlocks(boolean noMoreTsBlocks) {
        logger.info("SharedTsBlockQueue receive no more TsBlocks signal.");
        if (this.destroyed) {
            throw new IllegalStateException("queue has been destroyed");
        }
        this.noMoreTsBlocks = noMoreTsBlocks;
        if (!this.blocked.isDone()) {
            this.blocked.set(null);
        }
        if (this.sourceHandle != null) {
            this.sourceHandle.checkAndInvokeOnFinished();
        }
    }

    public TsBlock remove() {
        if (this.destroyed) {
            throw new IllegalStateException("queue has been destroyed");
        }
        TsBlock tsBlock = this.queue.remove();
        if (this.sinkHandle != null) {
            this.sinkHandle.checkAndInvokeOnFinished();
        }
        this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), tsBlock.getRetainedSizeInBytes());
        this.bufferRetainedSizeInBytes -= tsBlock.getRetainedSizeInBytes();
        if (this.blocked.isDone() && this.queue.isEmpty() && !this.noMoreTsBlocks) {
            this.blocked = SettableFuture.create();
        }
        return tsBlock;
    }

    public ListenableFuture<Void> add(TsBlock tsBlock) {
        if (this.destroyed) {
            throw new IllegalStateException("queue has been destroyed");
        }
        Validate.notNull((Object)tsBlock, (String)"TsBlock cannot be null", (Object[])new Object[0]);
        Validate.isTrue((this.blockedOnMemory == null || this.blockedOnMemory.isDone() ? 1 : 0) != 0, (String)"queue is full", (Object[])new Object[0]);
        this.blockedOnMemory = this.localMemoryManager.getQueryPool().reserve(this.localFragmentInstanceId.getQueryId(), tsBlock.getRetainedSizeInBytes());
        this.bufferRetainedSizeInBytes += tsBlock.getRetainedSizeInBytes();
        this.queue.add(tsBlock);
        if (!this.blocked.isDone()) {
            this.blocked.set(null);
        }
        return this.blockedOnMemory;
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (!this.blocked.isDone()) {
            this.blocked.set(null);
        }
        if (this.blockedOnMemory != null) {
            this.bufferRetainedSizeInBytes -= this.localMemoryManager.getQueryPool().tryCancel(this.blockedOnMemory);
        }
        this.queue.clear();
        if (this.bufferRetainedSizeInBytes > 0L) {
            this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), this.bufferRetainedSizeInBytes);
            this.bufferRetainedSizeInBytes = 0L;
        }
    }
}

