/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.mpp.common.header.HeaderConstant;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public class NodePathsCountOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final Operator child;
    private boolean isFinished;
    private final Set<String> nodePaths;

    public NodePathsCountOperator(OperatorContext operatorContext, Operator child) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.child = Objects.requireNonNull(child, "child operator is null");
        this.isFinished = false;
        this.nodePaths = new HashSet<String>();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        this.isFinished = true;
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(HeaderConstant.countNodesHeader.getRespDataTypes());
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        tsBlockBuilder.getColumnBuilder(0).writeInt(this.nodePaths.size());
        tsBlockBuilder.declarePosition();
        return tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ListenableFuture<?> blocked = this.child.isBlocked();
        while (this.child.hasNext() && blocked.isDone()) {
            TsBlock tsBlock = this.child.next();
            if (null != tsBlock && !tsBlock.isEmpty()) {
                for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                    String path = tsBlock.getColumn(0).getBinary(i).toString();
                    this.nodePaths.add(path);
                }
            }
            blocked = this.child.isBlocked();
        }
        if (!blocked.isDone()) {
            return blocked;
        }
        return NOT_BLOCKED;
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }
}

