/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.source;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.operator.source.SeriesScanUtil;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.universal.AlignedDescPriorityMergeReader;
import org.apache.iotdb.db.query.reader.universal.AlignedPriorityMergeReader;
import org.apache.iotdb.db.query.reader.universal.DescPriorityMergeReader;
import org.apache.iotdb.db.query.reader.universal.PriorityMergeReader;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.tsfile.file.metadata.AlignedTimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class AlignedSeriesScanUtil
extends SeriesScanUtil {
    private final List<TSDataType> dataTypes;

    public AlignedSeriesScanUtil(PartialPath seriesPath, Set<String> allSensors, FragmentInstanceContext context, Filter timeFilter, Filter valueFilter, boolean ascending) {
        super(seriesPath, allSensors, TSDataType.VECTOR, context, timeFilter, valueFilter, ascending);
        this.dataTypes = ((AlignedPath)seriesPath).getSchemaList().stream().map(IMeasurementSchema::getType).collect(Collectors.toList());
    }

    @Override
    protected PriorityMergeReader getPriorityMergeReader() {
        return new AlignedPriorityMergeReader();
    }

    @Override
    protected DescPriorityMergeReader getDescPriorityMergeReader() {
        return new AlignedDescPriorityMergeReader();
    }

    protected AlignedTimeSeriesMetadata loadTimeSeriesMetadata(TsFileResource resource, PartialPath seriesPath, QueryContext context, Filter filter, Set<String> allSensors) throws IOException {
        return FileLoaderUtils.loadTimeSeriesMetadata(resource, (AlignedPath)seriesPath, context, filter);
    }

    @Override
    protected List<TSDataType> getTsDataTypeList() {
        return this.dataTypes;
    }

    @Override
    protected IPointReader getPointReader(TsBlock tsBlock) {
        return tsBlock.getTsBlockAlignedRowIterator();
    }
}

