/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import io.airlift.concurrent.SetThreadName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.cache.DataNodeSchemaCache;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PathDeserializeUtil;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.mpp.common.schematree.PathPatternTree;
import org.apache.iotdb.db.mpp.common.schematree.SchemaTree;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.statement.internal.InternalCreateTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.internal.SchemaFetchStatement;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class ClusterSchemaFetcher
implements ISchemaFetcher {
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Coordinator coordinator = Coordinator.getInstance();
    private final IPartitionFetcher partitionFetcher = ClusterPartitionFetcher.getInstance();
    private final DataNodeSchemaCache schemaCache = DataNodeSchemaCache.getInstance();

    public static ClusterSchemaFetcher getInstance() {
        return ClusterSchemaFetcherHolder.INSTANCE;
    }

    private ClusterSchemaFetcher() {
    }

    @Override
    public SchemaTree fetchSchema(PathPatternTree patternTree) {
        return this.fetchSchema(patternTree, this.partitionFetcher.getSchemaPartition(patternTree));
    }

    @Override
    public SchemaTree fetchSchema(PathPatternTree patternTree, SchemaPartition schemaPartition) {
        Map schemaPartitionMap = schemaPartition.getSchemaPartitionMap();
        ArrayList<String> storageGroups = new ArrayList<String>(schemaPartitionMap.keySet());
        SchemaFetchStatement schemaFetchStatement = new SchemaFetchStatement(patternTree);
        schemaFetchStatement.setSchemaPartition(schemaPartition);
        SchemaTree result = this.executeSchemaFetchQuery(schemaFetchStatement);
        result.setStorageGroups(storageGroups);
        return result;
    }

    /*
     * Loose catch block
     */
    private SchemaTree executeSchemaFetchQuery(SchemaFetchStatement schemaFetchStatement) {
        long queryId = SessionManager.getInstance().requestQueryId(false);
        try {
            ExecutionResult executionResult = this.coordinator.execute(schemaFetchStatement, queryId, null, "", this.partitionFetcher, this);
            if (executionResult.status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new RuntimeException(String.format("cannot fetch schema, status is: %s, msg is: %s", executionResult.status.getCode(), executionResult.status.getMessage()));
            }
            try (SetThreadName threadName = new SetThreadName(executionResult.queryId.getId(), new Object[0]);){
                Optional<TsBlock> tsBlock;
                SchemaTree result = new SchemaTree();
                while (this.coordinator.getQueryExecution(queryId).hasNextResult() && (tsBlock = this.coordinator.getQueryExecution(queryId).getBatchResult()).isPresent() && !tsBlock.get().isEmpty()) {
                    Column column = tsBlock.get().getColumn(0);
                    for (int i = 0; i < column.getPositionCount(); ++i) {
                        Binary binary = column.getBinary(i);
                        try {
                            SchemaTree fetchedSchemaTree = SchemaTree.deserialize(new ByteArrayInputStream(binary.getValues()));
                            result.mergeSchemaTree(fetchedSchemaTree);
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                SchemaTree schemaTree = result;
                return schemaTree;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.coordinator.removeQueryExecution(queryId);
        }
    }

    @Override
    public SchemaTree fetchSchemaWithAutoCreate(PartialPath devicePath, String[] measurements, TSDataType[] tsDataTypes, boolean isAligned) {
        SchemaTree remoteSchemaTree;
        SchemaTree schemaTree = this.schemaCache.get(devicePath, measurements);
        Pair<List<String>, List<TSDataType>> missingMeasurements = this.checkMissingMeasurements(schemaTree, devicePath, measurements, tsDataTypes);
        PathPatternTree patternTree = new PathPatternTree();
        for (String measurement : (List)missingMeasurements.left) {
            patternTree.appendFullPath(devicePath, measurement);
        }
        if (patternTree.isEmpty()) {
            return schemaTree;
        }
        if (!this.config.isAutoCreateSchemaEnabled()) {
            remoteSchemaTree = this.fetchSchema(patternTree, this.partitionFetcher.getSchemaPartition(patternTree));
            schemaTree.mergeSchemaTree(remoteSchemaTree);
            this.schemaCache.put(remoteSchemaTree);
            return schemaTree;
        }
        remoteSchemaTree = this.fetchSchema(patternTree, this.partitionFetcher.getOrCreateSchemaPartition(patternTree));
        schemaTree.mergeSchemaTree(remoteSchemaTree);
        this.schemaCache.put(remoteSchemaTree);
        SchemaTree missingSchemaTree = this.checkAndAutoCreateMissingMeasurements(remoteSchemaTree, devicePath, ((List)missingMeasurements.left).toArray(new String[0]), ((List)missingMeasurements.right).toArray(new TSDataType[0]), isAligned);
        schemaTree.mergeSchemaTree(missingSchemaTree);
        this.schemaCache.put(missingSchemaTree);
        return schemaTree;
    }

    @Override
    public SchemaTree fetchSchemaListWithAutoCreate(List<PartialPath> devicePathList, List<String[]> measurementsList, List<TSDataType[]> tsDataTypesList, List<Boolean> isAlignedList) {
        SchemaTree schemaTree = new SchemaTree();
        PathPatternTree patternTree = new PathPatternTree();
        for (int i = 0; i < devicePathList.size(); ++i) {
            schemaTree.mergeSchemaTree(this.schemaCache.get(devicePathList.get(i), measurementsList.get(i)));
            List missingMeasurements = (List)this.checkMissingMeasurements((SchemaTree)schemaTree, (PartialPath)devicePathList.get((int)i), (String[])measurementsList.get((int)i), (TSDataType[])tsDataTypesList.get((int)i)).left;
            for (String measurement : missingMeasurements) {
                patternTree.appendFullPath(devicePathList.get(i), measurement);
            }
        }
        if (patternTree.isEmpty()) {
            return schemaTree;
        }
        if (!this.config.isAutoCreateSchemaEnabled()) {
            SchemaTree remoteSchemaTree = this.fetchSchema(patternTree, this.partitionFetcher.getSchemaPartition(patternTree));
            schemaTree.mergeSchemaTree(remoteSchemaTree);
            this.schemaCache.put(remoteSchemaTree);
            return schemaTree;
        }
        SchemaTree remoteSchemaTree = this.fetchSchema(patternTree, this.partitionFetcher.getOrCreateSchemaPartition(patternTree));
        schemaTree.mergeSchemaTree(remoteSchemaTree);
        this.schemaCache.put(remoteSchemaTree);
        for (int i = 0; i < devicePathList.size(); ++i) {
            SchemaTree missingSchemaTree = this.checkAndAutoCreateMissingMeasurements(schemaTree, devicePathList.get(i), measurementsList.get(i), tsDataTypesList.get(i), isAlignedList.get(i));
            schemaTree.mergeSchemaTree(missingSchemaTree);
            this.schemaCache.put(missingSchemaTree);
        }
        return schemaTree;
    }

    private SchemaTree checkAndAutoCreateMissingMeasurements(SchemaTree schemaTree, PartialPath devicePath, String[] measurements, TSDataType[] tsDataTypes, boolean isAligned) {
        Pair<List<String>, List<TSDataType>> checkResult = this.checkMissingMeasurements(schemaTree, devicePath, measurements, tsDataTypes);
        List missingMeasurements = (List)checkResult.left;
        List dataTypesOfMissingMeasurement = (List)checkResult.right;
        if (missingMeasurements.isEmpty()) {
            return new SchemaTree();
        }
        return this.internalCreateTimeseries(devicePath, missingMeasurements, dataTypesOfMissingMeasurement, isAligned);
    }

    private Pair<List<String>, List<TSDataType>> checkMissingMeasurements(SchemaTree schemaTree, PartialPath devicePath, String[] measurements, TSDataType[] tsDataTypes) {
        DeviceSchemaInfo deviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(devicePath, Arrays.asList(measurements));
        if (deviceSchemaInfo == null) {
            return new Pair(Arrays.asList(measurements), Arrays.asList(tsDataTypes));
        }
        ArrayList<String> missingMeasurements = new ArrayList<String>();
        ArrayList<TSDataType> dataTypesOfMissingMeasurement = new ArrayList<TSDataType>();
        List<MeasurementSchema> schemaList = deviceSchemaInfo.getMeasurementSchemaList();
        for (int i = 0; i < measurements.length; ++i) {
            if (schemaList.get(i) != null) continue;
            missingMeasurements.add(measurements[i]);
            dataTypesOfMissingMeasurement.add(tsDataTypes[i]);
        }
        return new Pair(missingMeasurements, dataTypesOfMissingMeasurement);
    }

    private SchemaTree internalCreateTimeseries(PartialPath devicePath, List<String> measurements, List<TSDataType> tsDataTypes, boolean isAligned) {
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
        for (TSDataType dataType : tsDataTypes) {
            encodings.add(EncodingInferenceUtils.getDefaultEncoding(dataType));
            compressors.add(TSFileDescriptor.getInstance().getConfig().getCompressor());
        }
        List<MeasurementPath> measurementPathList = this.executeInternalCreateTimeseriesStatement(new InternalCreateTimeSeriesStatement(devicePath, measurements, tsDataTypes, encodings, compressors, isAligned));
        Set alreadyExistingMeasurementIndexSet = measurementPathList.stream().map(o -> measurements.indexOf(o.getMeasurement())).collect(Collectors.toSet());
        SchemaTree schemaTree = new SchemaTree();
        schemaTree.appendMeasurementPaths(measurementPathList);
        int size = measurements.size();
        for (int i = 0; i < size; ++i) {
            if (alreadyExistingMeasurementIndexSet.contains(i)) continue;
            schemaTree.appendSingleMeasurement(devicePath.concatNode(measurements.get(i)), new MeasurementSchema(measurements.get(i), tsDataTypes.get(i), (TSEncoding)encodings.get(i), (CompressionType)compressors.get(i)), null, isAligned);
        }
        return schemaTree;
    }

    private List<MeasurementPath> executeInternalCreateTimeseriesStatement(InternalCreateTimeSeriesStatement statement) {
        long queryId = SessionManager.getInstance().requestQueryId(false);
        ExecutionResult executionResult = this.coordinator.execute(statement, queryId, null, "", this.partitionFetcher, this);
        int statusCode = executionResult.status.getCode();
        if (statusCode == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return Collections.emptyList();
        }
        ArrayList<String> failedCreationList = new ArrayList<String>();
        ArrayList<MeasurementPath> alreadyExistingMeasurements = new ArrayList<MeasurementPath>();
        for (TSStatus subStatus : executionResult.status.subStatus) {
            if (subStatus.code == TSStatusCode.MEASUREMENT_ALREADY_EXIST.getStatusCode()) {
                alreadyExistingMeasurements.add((MeasurementPath)PathDeserializeUtil.deserialize(ByteBuffer.wrap(subStatus.getMessage().getBytes())));
                continue;
            }
            failedCreationList.add(subStatus.message);
        }
        if (!failedCreationList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String message : failedCreationList) {
                stringBuilder.append(message).append("\n");
            }
            throw new RuntimeException(String.format("Failed to auto create schema\n %s", stringBuilder));
        }
        return alreadyExistingMeasurements;
    }

    @Override
    public void invalidAllCache() {
        DataNodeSchemaCache.getInstance().cleanUp();
    }

    private static final class ClusterSchemaFetcherHolder {
        private static final ClusterSchemaFetcher INSTANCE = new ClusterSchemaFetcher();

        private ClusterSchemaFetcherHolder() {
        }
    }
}

