/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import org.apache.iotdb.db.conf.IoTDBDescriptor;

public class ColumnPaginationController {
    private int curLimit = IoTDBDescriptor.getInstance().getConfig().getMaxQueryDeduplicatedPathNum() + 1;
    private int curOffset;
    private final boolean isDisabled;

    public ColumnPaginationController(int seriesLimit, int seriesOffset, boolean isDisabled) {
        this.curLimit = seriesLimit == 0 ? this.curLimit : Math.min(seriesLimit, this.curLimit);
        int seriesOffset1 = this.curOffset = seriesOffset;
        this.isDisabled = isDisabled;
    }

    public boolean hasCurOffset() {
        if (this.isDisabled) {
            return false;
        }
        return this.curOffset != 0;
    }

    public boolean hasCurLimit() {
        if (this.isDisabled) {
            return true;
        }
        return this.curLimit != 0;
    }

    public void consumeOffset() {
        if (this.isDisabled) {
            return;
        }
        --this.curOffset;
    }

    public void consumeLimit() {
        if (this.isDisabled) {
            return;
        }
        --this.curLimit;
    }
}

