/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.common.schematree.SchemaTree;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.StandaloneSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.BatchInsertNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;

public class SchemaValidator {
    private static final ISchemaFetcher SCHEMA_FETCHER = IoTDBDescriptor.getInstance().getConfig().isClusterMode() ? ClusterSchemaFetcher.getInstance() : StandaloneSchemaFetcher.getInstance();

    public static SchemaTree validate(InsertNode insertNode) {
        SchemaTree schemaTree;
        if (insertNode instanceof BatchInsertNode) {
            BatchInsertNode batchInsertNode = (BatchInsertNode)((Object)insertNode);
            schemaTree = SCHEMA_FETCHER.fetchSchemaListWithAutoCreate(batchInsertNode.getDevicePaths(), batchInsertNode.getMeasurementsList(), batchInsertNode.getDataTypesList(), batchInsertNode.getAlignedList());
        } else {
            schemaTree = SCHEMA_FETCHER.fetchSchemaWithAutoCreate(insertNode.getDevicePath(), insertNode.getMeasurements(), insertNode.getDataTypes(), insertNode.isAligned());
        }
        if (!insertNode.validateAndSetSchema(schemaTree)) {
            throw new SemanticException("Data type mismatch");
        }
        return schemaTree;
    }
}

