/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.localconfignode.LocalConfigNode;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.mpp.common.schematree.PathPatternTree;
import org.apache.iotdb.db.mpp.common.schematree.SchemaTree;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class StandaloneSchemaFetcher
implements ISchemaFetcher {
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final LocalConfigNode localConfigNode = LocalConfigNode.getInstance();
    private final SchemaEngine schemaEngine = SchemaEngine.getInstance();

    private StandaloneSchemaFetcher() {
    }

    public static StandaloneSchemaFetcher getInstance() {
        return new StandaloneSchemaFetcher();
    }

    @Override
    public SchemaTree fetchSchema(PathPatternTree patternTree) {
        patternTree.constructTree();
        HashSet<String> storageGroupSet = new HashSet<String>();
        SchemaTree schemaTree = new SchemaTree();
        List<PartialPath> pathPatterns = patternTree.getAllPathPatterns();
        try {
            for (PartialPath pathPattern : pathPatterns) {
                List<PartialPath> storageGroups = this.localConfigNode.getBelongedStorageGroups(pathPattern);
                for (PartialPath storageGroupPath : storageGroups) {
                    storageGroupSet.add(storageGroupPath.getFullPath());
                    SchemaRegionId schemaRegionId = this.localConfigNode.getBelongedSchemaRegionId(storageGroupPath);
                    ISchemaRegion schemaRegion = this.schemaEngine.getSchemaRegion(schemaRegionId);
                    schemaTree.appendMeasurementPaths(schemaRegion.getMeasurementPaths(pathPattern, false));
                }
            }
        }
        catch (MetadataException e) {
            throw new RuntimeException(e);
        }
        schemaTree.setStorageGroups(new ArrayList<String>(storageGroupSet));
        return schemaTree;
    }

    @Override
    public SchemaTree fetchSchema(PathPatternTree patternTree, SchemaPartition schemaPartition) {
        return this.fetchSchema(patternTree);
    }

    @Override
    public SchemaTree fetchSchemaWithAutoCreate(PartialPath devicePath, String[] measurements, TSDataType[] tsDataTypes, boolean aligned) {
        SchemaTree fetchedSchemaTree;
        SchemaTree schemaTree = new SchemaTree();
        PathPatternTree patternTree = new PathPatternTree();
        for (String measurement : measurements) {
            patternTree.appendFullPath(devicePath, measurement);
        }
        if (patternTree.isEmpty()) {
            return schemaTree;
        }
        if (!this.config.isAutoCreateSchemaEnabled()) {
            fetchedSchemaTree = this.fetchSchema(patternTree);
            schemaTree.mergeSchemaTree(fetchedSchemaTree);
            return schemaTree;
        }
        fetchedSchemaTree = this.fetchSchema(patternTree);
        schemaTree.mergeSchemaTree(fetchedSchemaTree);
        SchemaTree missingSchemaTree = this.checkAndAutoCreateMissingMeasurements(fetchedSchemaTree, devicePath, measurements, tsDataTypes, aligned);
        schemaTree.mergeSchemaTree(missingSchemaTree);
        return schemaTree;
    }

    @Override
    public SchemaTree fetchSchemaListWithAutoCreate(List<PartialPath> devicePathList, List<String[]> measurementsList, List<TSDataType[]> tsDataTypesList, List<Boolean> isAlignedList) {
        SchemaTree schemaTree = new SchemaTree();
        PathPatternTree patternTree = new PathPatternTree();
        for (int i = 0; i < devicePathList.size(); ++i) {
            for (String measurement : measurementsList.get(i)) {
                patternTree.appendFullPath(devicePathList.get(i), measurement);
            }
        }
        if (patternTree.isEmpty()) {
            return schemaTree;
        }
        if (!this.config.isAutoCreateSchemaEnabled()) {
            SchemaTree fetchedSchemaTree = this.fetchSchema(patternTree);
            schemaTree.mergeSchemaTree(fetchedSchemaTree);
            return schemaTree;
        }
        SchemaTree fetchedSchemaTree = this.fetchSchema(patternTree);
        schemaTree.mergeSchemaTree(fetchedSchemaTree);
        for (int i = 0; i < devicePathList.size(); ++i) {
            SchemaTree missingSchemaTree = this.checkAndAutoCreateMissingMeasurements(schemaTree, devicePathList.get(i), measurementsList.get(i), tsDataTypesList.get(i), isAlignedList.get(i));
            schemaTree.mergeSchemaTree(missingSchemaTree);
        }
        return schemaTree;
    }

    @Override
    public void invalidAllCache() {
    }

    private Pair<List<String>, List<TSDataType>> checkMissingMeasurements(SchemaTree schemaTree, PartialPath devicePath, String[] measurements, TSDataType[] tsDataTypes) {
        DeviceSchemaInfo deviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(devicePath, Arrays.asList(measurements));
        if (deviceSchemaInfo == null) {
            return new Pair(Arrays.asList(measurements), Arrays.asList(tsDataTypes));
        }
        ArrayList<String> missingMeasurements = new ArrayList<String>();
        ArrayList<TSDataType> dataTypesOfMissingMeasurement = new ArrayList<TSDataType>();
        List<MeasurementSchema> schemaList = deviceSchemaInfo.getMeasurementSchemaList();
        for (int i = 0; i < measurements.length; ++i) {
            if (schemaList.get(i) != null) continue;
            missingMeasurements.add(measurements[i]);
            dataTypesOfMissingMeasurement.add(tsDataTypes[i]);
        }
        return new Pair(missingMeasurements, dataTypesOfMissingMeasurement);
    }

    private SchemaTree checkAndAutoCreateMissingMeasurements(SchemaTree schemaTree, PartialPath devicePath, String[] measurements, TSDataType[] tsDataTypes, boolean isAligned) {
        Pair<List<String>, List<TSDataType>> checkResult = this.checkMissingMeasurements(schemaTree, devicePath, measurements, tsDataTypes);
        List missingMeasurements = (List)checkResult.left;
        List dataTypesOfMissingMeasurement = (List)checkResult.right;
        if (missingMeasurements.isEmpty()) {
            return new SchemaTree();
        }
        this.internalCreateTimeseries(devicePath, missingMeasurements, dataTypesOfMissingMeasurement, isAligned);
        PathPatternTree patternTree = new PathPatternTree();
        for (String measurement : missingMeasurements) {
            patternTree.appendFullPath(devicePath, measurement);
        }
        SchemaTree reFetchSchemaTree = this.fetchSchema(patternTree);
        Pair<List<String>, List<TSDataType>> recheckResult = this.checkMissingMeasurements(reFetchSchemaTree, devicePath, missingMeasurements.toArray(new String[0]), dataTypesOfMissingMeasurement.toArray(new TSDataType[0]));
        missingMeasurements = (List)recheckResult.left;
        if (!missingMeasurements.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            for (String missingMeasurement : missingMeasurements) {
                stringBuilder.append(missingMeasurement).append(" ");
            }
            stringBuilder.append(")");
            throw new RuntimeException(String.format("Failed to auto create schema, devicePath: %s, measurements: %s", devicePath.getFullPath(), stringBuilder));
        }
        return reFetchSchemaTree;
    }

    private void internalCreateTimeseries(PartialPath devicePath, List<String> measurements, List<TSDataType> tsDataTypes, boolean isAligned) {
        try {
            if (isAligned) {
                CreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan = new CreateAlignedTimeSeriesPlan();
                createAlignedTimeSeriesPlan.setPrefixPath(devicePath);
                createAlignedTimeSeriesPlan.setMeasurements(measurements);
                createAlignedTimeSeriesPlan.setDataTypes(tsDataTypes);
                ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
                ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
                for (TSDataType dataType : tsDataTypes) {
                    encodings.add(EncodingInferenceUtils.getDefaultEncoding(dataType));
                    compressors.add(TSFileDescriptor.getInstance().getConfig().getCompressor());
                }
                createAlignedTimeSeriesPlan.setEncodings(encodings);
                createAlignedTimeSeriesPlan.setCompressors(compressors);
                SchemaRegionId schemaRegionId = this.localConfigNode.getBelongedSchemaRegionIdWithAutoCreate(devicePath);
                ISchemaRegion schemaRegion = this.schemaEngine.getSchemaRegion(schemaRegionId);
                schemaRegion.createAlignedTimeSeries(createAlignedTimeSeriesPlan);
            } else {
                for (int i = 0; i < measurements.size(); ++i) {
                    CreateTimeSeriesPlan createTimeSeriesPlan = new CreateTimeSeriesPlan();
                    createTimeSeriesPlan.setPath(new PartialPath(devicePath.getFullPath(), measurements.get(i)));
                    createTimeSeriesPlan.setDataType(tsDataTypes.get(i));
                    createTimeSeriesPlan.setEncoding(EncodingInferenceUtils.getDefaultEncoding(tsDataTypes.get(i)));
                    createTimeSeriesPlan.setCompressor(TSFileDescriptor.getInstance().getConfig().getCompressor());
                    SchemaRegionId schemaRegionId = this.localConfigNode.getBelongedSchemaRegionIdWithAutoCreate(devicePath);
                    ISchemaRegion schemaRegion = this.schemaEngine.getSchemaRegion(schemaRegionId);
                    schemaRegion.createTimeseries(createTimeSeriesPlan, -1L);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("cannot auto create schema ", e);
        }
    }
}

