/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.binary.AdditionExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.DivisionExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.EqualToExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.ModuloExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.MultiplicationExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.NonEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.SubtractionExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.InExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.IsNullExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.NegationExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.RegularExpression;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.transformation.dag.input.QueryDataSetInputLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.IntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFContext;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.utils.WildcardsRemover;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class Expression {
    protected Integer inputColumnIndex = null;
    protected Boolean isConstantOperandCache = null;
    private String expressionStringCache;

    public boolean isBuiltInAggregationFunctionExpression() {
        return false;
    }

    public boolean isUserDefinedAggregationFunctionExpression() {
        return false;
    }

    public boolean isTimeSeriesGeneratingFunctionExpression() {
        return false;
    }

    @Deprecated
    public abstract void concat(List<PartialPath> var1, List<Expression> var2);

    @Deprecated
    public abstract void removeWildcards(WildcardsRemover var1, List<Expression> var2) throws LogicalOptimizeException;

    @Deprecated
    public abstract void collectPaths(Set<PartialPath> var1);

    public abstract void constructUdfExecutors(Map<String, UDTFExecutor> var1, ZoneId var2);

    public abstract TSDataType inferTypes(TypeProvider var1);

    protected static void checkInputExpressionDataType(String expressionString, TSDataType actual, TSDataType ... expected) {
        for (TSDataType type : expected) {
            if (!actual.equals((Object)type)) continue;
            return;
        }
        throw new SemanticException(String.format("Invalid input expression data type. expression: %s, actual data type: %s, expected data type(s): %s.", expressionString, actual.name(), Arrays.toString(expected)));
    }

    @Deprecated
    public abstract void bindInputLayerColumnIndexWithExpression(UDTFPlan var1);

    public abstract void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> var1);

    public abstract void updateStatisticsForMemoryAssigner(LayerMemoryAssigner var1);

    @Deprecated
    public abstract IntermediateLayer constructIntermediateLayer(long var1, UDTFContext var3, QueryDataSetInputLayer var4, Map<Expression, IntermediateLayer> var5, Map<Expression, TSDataType> var6, LayerMemoryAssigner var7) throws QueryProcessException, IOException;

    public abstract IntermediateLayer constructIntermediateLayer(long var1, UDTFContext var3, QueryDataSetInputLayer var4, Map<Expression, IntermediateLayer> var5, TypeProvider var6, LayerMemoryAssigner var7) throws QueryProcessException, IOException;

    public final boolean isConstantOperand() {
        if (this.isConstantOperandCache == null) {
            this.isConstantOperandCache = this.isConstantOperandInternal();
        }
        return this.isConstantOperandCache;
    }

    protected abstract boolean isConstantOperandInternal();

    public final String toString() {
        return this.getExpressionString();
    }

    public final String getExpressionString() {
        if (this.expressionStringCache == null) {
            this.expressionStringCache = this.getExpressionStringInternal();
        }
        return this.expressionStringCache;
    }

    protected abstract String getExpressionStringInternal();

    public final int hashCode() {
        return this.getExpressionString().hashCode();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Expression)) {
            return false;
        }
        return this.getExpressionString().equals(((Expression)o).getExpressionString());
    }

    public final Iterator<Expression> iterator() {
        return new ExpressionIterator(this);
    }

    public abstract List<Expression> getExpressions();

    public static void serialize(Expression expression, ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((short)expression.getExpressionType().getExpressionTypeInShortEnum(), (ByteBuffer)byteBuffer);
        expression.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)(expression.inputColumnIndex != null ? 1 : 0), (ByteBuffer)byteBuffer);
        if (expression.inputColumnIndex != null) {
            ReadWriteIOUtils.write((int)expression.inputColumnIndex, (ByteBuffer)byteBuffer);
        }
    }

    public static void serialize(Expression expression, DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((short)expression.getExpressionType().getExpressionTypeInShortEnum(), (OutputStream)stream);
        expression.serialize(stream);
        ReadWriteIOUtils.write((Boolean)(expression.inputColumnIndex != null ? 1 : 0), (OutputStream)stream);
        if (expression.inputColumnIndex != null) {
            ReadWriteIOUtils.write((int)expression.inputColumnIndex, (OutputStream)stream);
        }
    }

    public static Expression deserialize(ByteBuffer byteBuffer) {
        Expression expression;
        short type = ReadWriteIOUtils.readShort((ByteBuffer)byteBuffer);
        switch (type) {
            case -4: {
                expression = new ConstantOperand(byteBuffer);
                break;
            }
            case -3: {
                expression = new TimestampOperand(byteBuffer);
                break;
            }
            case -2: {
                expression = new TimeSeriesOperand(byteBuffer);
                break;
            }
            case -1: {
                expression = new FunctionExpression(byteBuffer);
                break;
            }
            case 0: {
                expression = new NegationExpression(byteBuffer);
                break;
            }
            case 1: {
                expression = new LogicNotExpression(byteBuffer);
                break;
            }
            case 2: {
                expression = new MultiplicationExpression(byteBuffer);
                break;
            }
            case 3: {
                expression = new DivisionExpression(byteBuffer);
                break;
            }
            case 4: {
                expression = new ModuloExpression(byteBuffer);
                break;
            }
            case 5: {
                expression = new AdditionExpression(byteBuffer);
                break;
            }
            case 6: {
                expression = new SubtractionExpression(byteBuffer);
                break;
            }
            case 7: {
                expression = new EqualToExpression(byteBuffer);
                break;
            }
            case 8: {
                expression = new NonEqualExpression(byteBuffer);
                break;
            }
            case 9: {
                expression = new GreaterEqualExpression(byteBuffer);
                break;
            }
            case 10: {
                expression = new GreaterThanExpression(byteBuffer);
                break;
            }
            case 11: {
                expression = new LessEqualExpression(byteBuffer);
                break;
            }
            case 12: {
                expression = new LessThanExpression(byteBuffer);
                break;
            }
            case 13: {
                expression = new LikeExpression(byteBuffer);
                break;
            }
            case 14: {
                expression = new RegularExpression(byteBuffer);
                break;
            }
            case 15: {
                expression = new IsNullExpression(byteBuffer);
                break;
            }
            case 17: {
                expression = new InExpression(byteBuffer);
                break;
            }
            case 18: {
                expression = new LogicAndExpression(byteBuffer);
                break;
            }
            case 19: {
                expression = new LogicOrExpression(byteBuffer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid expression type: " + type);
            }
        }
        boolean hasInputColumnIndex = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        if (hasInputColumnIndex) {
            expression.inputColumnIndex = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        }
        return expression;
    }

    public abstract ExpressionType getExpressionType();

    protected abstract void serialize(ByteBuffer var1);

    protected abstract void serialize(DataOutputStream var1) throws IOException;

    private static class ExpressionIterator
    implements Iterator<Expression> {
        private final Deque<Expression> queue = new LinkedList<Expression>();

        public ExpressionIterator(Expression expression) {
            this.queue.add(expression);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public Expression next() {
            if (!this.hasNext()) {
                return null;
            }
            Expression current = this.queue.pop();
            if (current != null) {
                for (Expression subExp : current.getExpressions()) {
                    this.queue.push(subExp);
                }
            }
            return current;
        }
    }
}

