/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.binary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.binary.AdditionExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.DivisionExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.EqualToExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.ModuloExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.MultiplicationExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.NonEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.SubtractionExpression;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.input.QueryDataSetInputLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.IntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.SingleInputColumnMultiReferenceIntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.SingleInputColumnSingleReferenceIntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.binary.BinaryTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFContext;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.utils.WildcardsRemover;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class BinaryExpression
extends Expression {
    protected Expression leftExpression;
    protected Expression rightExpression;

    protected BinaryExpression(Expression leftExpression, Expression rightExpression) {
        this.leftExpression = leftExpression;
        this.rightExpression = rightExpression;
    }

    protected BinaryExpression(ByteBuffer byteBuffer) {
        this.leftExpression = Expression.deserialize(byteBuffer);
        this.rightExpression = Expression.deserialize(byteBuffer);
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public void setLeftExpression(Expression leftExpression) {
        this.leftExpression = leftExpression;
    }

    public void setRightExpression(Expression rightExpression) {
        this.rightExpression = rightExpression;
    }

    @Override
    public boolean isConstantOperandInternal() {
        return this.leftExpression.isConstantOperand() && this.rightExpression.isConstantOperand();
    }

    @Override
    public boolean isTimeSeriesGeneratingFunctionExpression() {
        return !this.isUserDefinedAggregationFunctionExpression();
    }

    @Override
    public boolean isUserDefinedAggregationFunctionExpression() {
        return this.leftExpression.isBuiltInAggregationFunctionExpression() || this.rightExpression.isBuiltInAggregationFunctionExpression() || this.leftExpression.isUserDefinedAggregationFunctionExpression() || this.rightExpression.isUserDefinedAggregationFunctionExpression();
    }

    @Override
    public List<Expression> getExpressions() {
        return Arrays.asList(this.leftExpression, this.rightExpression);
    }

    @Override
    public final void concat(List<PartialPath> prefixPaths, List<Expression> resultExpressions) {
        ArrayList<Expression> leftExpressions = new ArrayList<Expression>();
        this.leftExpression.concat(prefixPaths, leftExpressions);
        ArrayList<Expression> rightExpressions = new ArrayList<Expression>();
        this.rightExpression.concat(prefixPaths, rightExpressions);
        this.reconstruct(leftExpressions, rightExpressions, resultExpressions);
    }

    @Override
    public final void removeWildcards(WildcardsRemover wildcardsRemover, List<Expression> resultExpressions) throws LogicalOptimizeException {
        ArrayList<Expression> leftExpressions = new ArrayList<Expression>();
        this.leftExpression.removeWildcards(wildcardsRemover, leftExpressions);
        ArrayList<Expression> rightExpressions = new ArrayList<Expression>();
        this.rightExpression.removeWildcards(wildcardsRemover, rightExpressions);
        this.reconstruct(leftExpressions, rightExpressions, resultExpressions);
    }

    private void reconstruct(List<Expression> leftExpressions, List<Expression> rightExpressions, List<Expression> resultExpressions) {
        for (Expression le : leftExpressions) {
            block31: for (Expression re : rightExpressions) {
                switch (this.operator()) {
                    case "+": {
                        resultExpressions.add(new AdditionExpression(le, re));
                        continue block31;
                    }
                    case "-": {
                        resultExpressions.add(new SubtractionExpression(le, re));
                        continue block31;
                    }
                    case "*": {
                        resultExpressions.add(new MultiplicationExpression(le, re));
                        continue block31;
                    }
                    case "/": {
                        resultExpressions.add(new DivisionExpression(le, re));
                        continue block31;
                    }
                    case "%": {
                        resultExpressions.add(new ModuloExpression(le, re));
                        continue block31;
                    }
                    case "<": {
                        resultExpressions.add(new LessThanExpression(le, re));
                        continue block31;
                    }
                    case "<=": {
                        resultExpressions.add(new LessEqualExpression(le, re));
                        continue block31;
                    }
                    case ">": {
                        resultExpressions.add(new GreaterThanExpression(le, re));
                        continue block31;
                    }
                    case ">=": {
                        resultExpressions.add(new GreaterEqualExpression(le, re));
                        continue block31;
                    }
                    case "=": {
                        resultExpressions.add(new EqualToExpression(le, re));
                        continue block31;
                    }
                    case "!=": {
                        resultExpressions.add(new NonEqualExpression(le, re));
                        continue block31;
                    }
                    case "&": {
                        resultExpressions.add(new LogicAndExpression(le, re));
                        continue block31;
                    }
                    case "|": {
                        resultExpressions.add(new LogicOrExpression(le, re));
                        continue block31;
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void collectPaths(Set<PartialPath> pathSet) {
        this.leftExpression.collectPaths(pathSet);
        this.rightExpression.collectPaths(pathSet);
    }

    @Override
    public void constructUdfExecutors(Map<String, UDTFExecutor> expressionName2Executor, ZoneId zoneId) {
        this.leftExpression.constructUdfExecutors(expressionName2Executor, zoneId);
        this.rightExpression.constructUdfExecutors(expressionName2Executor, zoneId);
    }

    @Override
    public final void bindInputLayerColumnIndexWithExpression(UDTFPlan udtfPlan) {
        this.leftExpression.bindInputLayerColumnIndexWithExpression(udtfPlan);
        this.rightExpression.bindInputLayerColumnIndexWithExpression(udtfPlan);
        this.inputColumnIndex = udtfPlan.getReaderIndexByExpressionName(this.toString());
    }

    @Override
    public final void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> inputLocations) {
        this.leftExpression.bindInputLayerColumnIndexWithExpression(inputLocations);
        this.rightExpression.bindInputLayerColumnIndexWithExpression(inputLocations);
        String digest = this.toString();
        if (inputLocations.containsKey(digest)) {
            this.inputColumnIndex = inputLocations.get(digest).get(0).getValueColumnIndex();
        }
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        this.leftExpression.updateStatisticsForMemoryAssigner(memoryAssigner);
        this.rightExpression.updateStatisticsForMemoryAssigner(memoryAssigner);
        memoryAssigner.increaseExpressionReference(this);
    }

    @Override
    public IntermediateLayer constructIntermediateLayer(long queryId, UDTFContext udtfContext, QueryDataSetInputLayer rawTimeSeriesInputLayer, Map<Expression, IntermediateLayer> expressionIntermediateLayerMap, Map<Expression, TSDataType> expressionDataTypeMap, LayerMemoryAssigner memoryAssigner) throws QueryProcessException, IOException {
        if (!expressionIntermediateLayerMap.containsKey(this)) {
            float memoryBudgetInMB = memoryAssigner.assign();
            IntermediateLayer leftParentIntermediateLayer = this.leftExpression.constructIntermediateLayer(queryId, udtfContext, rawTimeSeriesInputLayer, expressionIntermediateLayerMap, expressionDataTypeMap, memoryAssigner);
            IntermediateLayer rightParentIntermediateLayer = this.rightExpression.constructIntermediateLayer(queryId, udtfContext, rawTimeSeriesInputLayer, expressionIntermediateLayerMap, expressionDataTypeMap, memoryAssigner);
            BinaryTransformer transformer = this.constructTransformer(leftParentIntermediateLayer.constructPointReader(), rightParentIntermediateLayer.constructPointReader());
            expressionDataTypeMap.put(this, transformer.getDataType());
            expressionIntermediateLayerMap.put(this, memoryAssigner.getReference(this) == 1 || this.isConstantOperand() ? new SingleInputColumnSingleReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, transformer) : new SingleInputColumnMultiReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, transformer));
        }
        return expressionIntermediateLayerMap.get(this);
    }

    @Override
    public IntermediateLayer constructIntermediateLayer(long queryId, UDTFContext udtfContext, QueryDataSetInputLayer rawTimeSeriesInputLayer, Map<Expression, IntermediateLayer> expressionIntermediateLayerMap, TypeProvider typeProvider, LayerMemoryAssigner memoryAssigner) throws QueryProcessException, IOException {
        if (!expressionIntermediateLayerMap.containsKey(this)) {
            float memoryBudgetInMB = memoryAssigner.assign();
            IntermediateLayer leftParentIntermediateLayer = this.leftExpression.constructIntermediateLayer(queryId, udtfContext, rawTimeSeriesInputLayer, expressionIntermediateLayerMap, typeProvider, memoryAssigner);
            IntermediateLayer rightParentIntermediateLayer = this.rightExpression.constructIntermediateLayer(queryId, udtfContext, rawTimeSeriesInputLayer, expressionIntermediateLayerMap, typeProvider, memoryAssigner);
            BinaryTransformer transformer = this.constructTransformer(leftParentIntermediateLayer.constructPointReader(), rightParentIntermediateLayer.constructPointReader());
            expressionIntermediateLayerMap.put(this, memoryAssigner.getReference(this) == 1 || this.isConstantOperand() ? new SingleInputColumnSingleReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, transformer) : new SingleInputColumnMultiReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, transformer));
        }
        return expressionIntermediateLayerMap.get(this);
    }

    protected abstract BinaryTransformer constructTransformer(LayerPointReader var1, LayerPointReader var2);

    @Override
    public final String getExpressionStringInternal() {
        StringBuilder builder = new StringBuilder();
        if (this.leftExpression.getExpressionType().getPriority() < this.getExpressionType().getPriority()) {
            builder.append("(").append(this.leftExpression.getExpressionString()).append(")");
        } else {
            builder.append(this.leftExpression.getExpressionString());
        }
        builder.append(" ").append(this.operator()).append(" ");
        if (this.rightExpression.getExpressionType().getPriority() < this.getExpressionType().getPriority()) {
            builder.append("(").append(this.rightExpression.getExpressionString()).append(")");
        } else {
            builder.append(this.rightExpression.getExpressionString());
        }
        return builder.toString();
    }

    protected abstract String operator();

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        Expression.serialize(this.leftExpression, byteBuffer);
        Expression.serialize(this.rightExpression, byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        Expression.serialize(this.leftExpression, stream);
        Expression.serialize(this.rightExpression, stream);
    }
}

