/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.unary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.Transformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.RegularTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LikeExpression
extends UnaryExpression {
    private final String patternString;
    private final Pattern pattern;

    public LikeExpression(Expression expression, String patternString) {
        super(expression);
        this.patternString = patternString;
        this.pattern = this.compile();
    }

    public LikeExpression(Expression expression, String patternString, Pattern pattern) {
        super(expression);
        this.patternString = patternString;
        this.pattern = pattern;
    }

    public LikeExpression(ByteBuffer byteBuffer) {
        super(Expression.deserialize(byteBuffer));
        this.patternString = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.pattern = this.compile();
    }

    public String getPatternString() {
        return this.patternString;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    private Pattern compile() {
        String unescapeValue = this.unescapeString(this.patternString);
        String specialRegexString = ".^$*+?{}[]|()";
        StringBuilder patternBuilder = new StringBuilder();
        patternBuilder.append("^");
        for (int i = 0; i < unescapeValue.length(); ++i) {
            String ch = String.valueOf(unescapeValue.charAt(i));
            if (specialRegexString.contains(ch)) {
                ch = "\\" + unescapeValue.charAt(i);
            }
            if (i == 0 || !"\\".equals(String.valueOf(unescapeValue.charAt(i - 1))) || i >= 2 && "\\\\".equals(patternBuilder.substring(patternBuilder.length() - 2, patternBuilder.length()))) {
                patternBuilder.append(ch.replace("%", ".*?").replace("_", "."));
                continue;
            }
            patternBuilder.append(ch);
        }
        patternBuilder.append("$");
        return Pattern.compile(patternBuilder.toString());
    }

    private String unescapeString(String value) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            String ch = String.valueOf(value.charAt(i));
            if ("\\".equals(ch)) {
                if (i >= value.length() - 1) continue;
                String nextChar = String.valueOf(value.charAt(i + 1));
                if ("%".equals(nextChar) || "_".equals(nextChar) || "\\".equals(nextChar)) {
                    stringBuilder.append(ch);
                }
                if (!"\\".equals(nextChar)) continue;
                ++i;
                continue;
            }
            stringBuilder.append(ch);
        }
        return stringBuilder.toString();
    }

    @Override
    public TSDataType inferTypes(TypeProvider typeProvider) throws SemanticException {
        String expressionString = this.toString();
        if (!typeProvider.containsTypeInfoOf(expressionString)) {
            LikeExpression.checkInputExpressionDataType(this.expression.toString(), this.expression.inferTypes(typeProvider), TSDataType.TEXT);
            typeProvider.setType(expressionString, TSDataType.BOOLEAN);
        }
        return TSDataType.BOOLEAN;
    }

    @Override
    protected String getExpressionStringInternal() {
        return this.expression + " LIKE '" + this.pattern + "'";
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.LIKE;
    }

    @Override
    protected Transformer constructTransformer(LayerPointReader pointReader) {
        return new RegularTransformer(pointReader, this.pattern);
    }

    @Override
    protected Expression constructExpression(Expression childExpression) {
        return new LikeExpression(childExpression, this.patternString, this.pattern);
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.patternString, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.patternString, (OutputStream)stream);
    }
}

