/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.unary;

import java.nio.ByteBuffer;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.Transformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.ArithmeticNegationTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class NegationExpression
extends UnaryExpression {
    public NegationExpression(Expression expression) {
        super(expression);
    }

    public NegationExpression(ByteBuffer byteBuffer) {
        super(Expression.deserialize(byteBuffer));
    }

    @Override
    protected Transformer constructTransformer(LayerPointReader pointReader) {
        return new ArithmeticNegationTransformer(pointReader);
    }

    @Override
    protected Expression constructExpression(Expression childExpression) {
        return new NegationExpression(childExpression);
    }

    @Override
    public TSDataType inferTypes(TypeProvider typeProvider) throws SemanticException {
        String expressionString = this.toString();
        if (!typeProvider.containsTypeInfoOf(expressionString)) {
            TSDataType inputExpressionType = this.expression.inferTypes(typeProvider);
            Expression.checkInputExpressionDataType(this.expression.toString(), inputExpressionType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
            typeProvider.setType(expressionString, inputExpressionType);
        }
        return typeProvider.getType(expressionString);
    }

    @Override
    public String getExpressionStringInternal() {
        return this.expression instanceof TimeSeriesOperand || this.expression instanceof FunctionExpression || this.expression instanceof ConstantOperand && !((ConstantOperand)this.expression).isNegativeNumber() ? "-" + this.expression : "-(" + this.expression + ")";
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.NEGATION;
    }
}

