/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.distribution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.planner.IFragmentParallelPlaner;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.mpp.plan.planner.plan.SubPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.sink.FragmentSinkNode;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class SimpleFragmentParallelPlanner
implements IFragmentParallelPlaner {
    private SubPlan subPlan;
    private Analysis analysis;
    private MPPQueryContext queryContext;
    Map<PlanFragmentId, FragmentInstance> instanceMap;
    Map<PlanNodeId, PlanFragmentId> planNodeMap;
    List<FragmentInstance> fragmentInstanceList;

    public SimpleFragmentParallelPlanner(SubPlan subPlan, Analysis analysis, MPPQueryContext context) {
        this.subPlan = subPlan;
        this.analysis = analysis;
        this.queryContext = context;
        this.instanceMap = new HashMap<PlanFragmentId, FragmentInstance>();
        this.planNodeMap = new HashMap<PlanNodeId, PlanFragmentId>();
        this.fragmentInstanceList = new ArrayList<FragmentInstance>();
    }

    @Override
    public List<FragmentInstance> parallelPlan() {
        this.prepare();
        this.calculateNodeTopologyBetweenInstance();
        return this.fragmentInstanceList;
    }

    private void prepare() {
        List<PlanFragment> fragments = this.subPlan.getPlanFragmentList();
        for (PlanFragment fragment : fragments) {
            this.recordPlanNodeRelation(fragment.getRoot(), fragment.getId());
            this.produceFragmentInstance(fragment);
        }
    }

    private void produceFragmentInstance(PlanFragment fragment) {
        PlanNode rootCopy = PlanNodeUtil.deepCopy(fragment.getRoot());
        Filter timeFilter = this.analysis.getGlobalTimeFilter();
        FragmentInstance fragmentInstance = new FragmentInstance(new PlanFragment(fragment.getId(), rootCopy), fragment.getId().genFragmentInstanceId(), timeFilter, this.queryContext.getQueryType());
        TRegionReplicaSet regionReplicaSet = fragment.getTargetRegion();
        fragmentInstance.setDataRegionAndHost(regionReplicaSet);
        fragmentInstance.getFragment().setTypeProvider(this.analysis.getTypeProvider());
        this.instanceMap.putIfAbsent(fragment.getId(), fragmentInstance);
        this.fragmentInstanceList.add(fragmentInstance);
    }

    private void calculateNodeTopologyBetweenInstance() {
        for (FragmentInstance instance : this.fragmentInstanceList) {
            PlanNode rootNode = instance.getFragment().getRoot();
            if (!(rootNode instanceof FragmentSinkNode)) continue;
            FragmentSinkNode sinkNode = (FragmentSinkNode)rootNode;
            PlanNodeId downStreamNodeId = sinkNode.getDownStreamPlanNodeId();
            FragmentInstance downStreamInstance = this.findDownStreamInstance(downStreamNodeId);
            sinkNode.setDownStream(downStreamInstance.getHostDataNode().getMPPDataExchangeEndPoint(), downStreamInstance.getId(), downStreamNodeId);
            PlanNode downStreamExchangeNode = downStreamInstance.getFragment().getPlanNodeById(downStreamNodeId);
            ((ExchangeNode)downStreamExchangeNode).setUpstream(instance.getHostDataNode().getMPPDataExchangeEndPoint(), instance.getId(), sinkNode.getPlanNodeId());
        }
    }

    private FragmentInstance findDownStreamInstance(PlanNodeId exchangeNodeId) {
        return this.instanceMap.get(this.planNodeMap.get(exchangeNodeId));
    }

    private void recordPlanNodeRelation(PlanNode root, PlanFragmentId planFragmentId) {
        this.planNodeMap.put(root.getPlanNodeId(), planFragmentId);
        for (PlanNode child : root.getChildren()) {
            this.recordPlanNodeRelation(child, planFragmentId);
        }
    }
}

