/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.transformer.multi;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerRowReader;
import org.apache.iotdb.db.mpp.transformation.api.YieldableState;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.multi.UDFQueryTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFExecutor;

public class UDFQueryRowTransformer
extends UDFQueryTransformer {
    protected final LayerRowReader layerRowReader;

    public UDFQueryRowTransformer(LayerRowReader layerRowReader, UDTFExecutor executor) {
        super(executor);
        this.layerRowReader = layerRowReader;
    }

    @Override
    protected YieldableState tryExecuteUDFOnce() throws QueryProcessException, IOException {
        YieldableState yieldableState = this.layerRowReader.yield();
        if (yieldableState != YieldableState.YIELDABLE) {
            return yieldableState;
        }
        if (this.layerRowReader.isCurrentNull()) {
            this.currentNull = true;
        }
        this.executor.execute(this.layerRowReader.currentRow(), this.currentNull);
        this.layerRowReader.readyForNext();
        return YieldableState.YIELDABLE;
    }

    @Override
    protected boolean executeUDFOnce() throws IOException, QueryProcessException {
        if (!this.layerRowReader.next()) {
            return false;
        }
        if (this.layerRowReader.isCurrentNull()) {
            this.currentNull = true;
        }
        this.executor.execute(this.layerRowReader.currentRow(), this.currentNull);
        this.layerRowReader.readyForNext();
        return true;
    }
}

