/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.datastructure.row;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.dag.util.InputRowUtils;
import org.apache.iotdb.db.mpp.transformation.datastructure.Cache;
import org.apache.iotdb.db.mpp.transformation.datastructure.SerializableList;
import org.apache.iotdb.db.mpp.transformation.datastructure.row.SerializableRowRecordList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;

public class ElasticSerializableRowRecordList {
    protected static final int MEMORY_CHECK_THRESHOLD = 1000;
    protected TSDataType[] dataTypes;
    protected long queryId;
    protected float memoryLimitInMB;
    protected int internalRowRecordListCapacity;
    protected int numCacheBlock;
    protected LRUCache cache;
    protected List<SerializableRowRecordList> rowRecordLists;
    protected List<BitMap> bitMaps;
    protected int size;
    protected int evictionUpperBound;
    protected boolean disableMemoryControl;
    protected int[] indexListOfTextFields;
    protected int byteArrayLengthForMemoryControl;
    protected long totalByteArrayLengthLimit;
    protected long totalByteArrayLength;

    public ElasticSerializableRowRecordList(TSDataType[] dataTypes, long queryId, float memoryLimitInMB, int numCacheBlock) throws QueryProcessException {
        this.dataTypes = dataTypes;
        this.queryId = queryId;
        this.memoryLimitInMB = memoryLimitInMB;
        int allocatableCapacity = SerializableRowRecordList.calculateCapacity(dataTypes, memoryLimitInMB, SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL);
        this.internalRowRecordListCapacity = allocatableCapacity / numCacheBlock;
        if (this.internalRowRecordListCapacity == 0) {
            numCacheBlock = 1;
            this.internalRowRecordListCapacity = allocatableCapacity;
        }
        this.numCacheBlock = numCacheBlock;
        this.cache = new LRUCache(numCacheBlock);
        this.rowRecordLists = new ArrayList<SerializableRowRecordList>();
        this.bitMaps = new ArrayList<BitMap>();
        this.size = 0;
        this.evictionUpperBound = 0;
        this.disableMemoryControl = true;
        int textFieldsCount = 0;
        for (TSDataType dataType : dataTypes) {
            if (!dataType.equals((Object)TSDataType.TEXT)) continue;
            ++textFieldsCount;
            this.disableMemoryControl = false;
        }
        this.indexListOfTextFields = new int[textFieldsCount];
        int fieldIndex = 0;
        for (int i = 0; i < dataTypes.length; ++i) {
            if (!dataTypes[i].equals((Object)TSDataType.TEXT)) continue;
            this.indexListOfTextFields[fieldIndex++] = i;
        }
        this.byteArrayLengthForMemoryControl = SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL;
        this.totalByteArrayLengthLimit = 0L;
        this.totalByteArrayLength = 0L;
    }

    protected ElasticSerializableRowRecordList(TSDataType[] dataTypes, long queryId, float memoryLimitInMB, int internalRowRecordListCapacity, int numCacheBlock) {
        this.dataTypes = dataTypes;
        this.queryId = queryId;
        this.memoryLimitInMB = memoryLimitInMB;
        this.internalRowRecordListCapacity = internalRowRecordListCapacity;
        this.numCacheBlock = numCacheBlock;
        this.cache = new LRUCache(numCacheBlock);
        this.rowRecordLists = new ArrayList<SerializableRowRecordList>();
        this.bitMaps = new ArrayList<BitMap>();
        this.size = 0;
        this.evictionUpperBound = 0;
        this.disableMemoryControl = true;
    }

    public int size() {
        return this.size;
    }

    public TSDataType[] getDataTypes() {
        return this.dataTypes;
    }

    public long getTime(int index) throws IOException {
        return this.cache.get(index / this.internalRowRecordListCapacity).getTime(index % this.internalRowRecordListCapacity);
    }

    public Object[] getRowRecord(int index) throws IOException {
        return this.cache.get(index / this.internalRowRecordListCapacity).getRowRecord(index % this.internalRowRecordListCapacity);
    }

    public boolean fieldsHasAnyNull(int index) {
        return this.bitMaps.get(index / this.internalRowRecordListCapacity).isMarked(index % this.internalRowRecordListCapacity);
    }

    public void put(Object[] rowRecord) throws IOException, QueryProcessException {
        this.put(rowRecord, InputRowUtils.hasNullField(rowRecord));
    }

    private void put(Object[] rowRecord, boolean hasNullField) throws IOException, QueryProcessException {
        this.checkExpansion();
        this.cache.get(this.size / this.internalRowRecordListCapacity).put(rowRecord);
        if (hasNullField) {
            this.bitMaps.get(this.size / this.internalRowRecordListCapacity).mark(this.size % this.internalRowRecordListCapacity);
        }
        ++this.size;
        if (!this.disableMemoryControl) {
            this.totalByteArrayLengthLimit += (long)this.indexListOfTextFields.length * (long)this.byteArrayLengthForMemoryControl;
            if (rowRecord == null) {
                this.totalByteArrayLength += (long)this.indexListOfTextFields.length * (long)this.byteArrayLengthForMemoryControl;
            } else {
                for (int indexListOfTextField : this.indexListOfTextFields) {
                    Binary binary = (Binary)rowRecord[indexListOfTextField];
                    this.totalByteArrayLength += binary == null ? 0L : (long)binary.getLength();
                }
                this.checkMemoryUsage();
            }
        }
    }

    private void checkExpansion() {
        if (this.size % this.internalRowRecordListCapacity == 0) {
            this.rowRecordLists.add(SerializableRowRecordList.newSerializableRowRecordList(this.queryId, this.dataTypes, this.internalRowRecordListCapacity));
            this.bitMaps.add(new BitMap(this.internalRowRecordListCapacity));
        }
    }

    protected void checkMemoryUsage() throws IOException, QueryProcessException {
        if (this.size % 1000 != 0 || this.totalByteArrayLength <= this.totalByteArrayLengthLimit) {
            return;
        }
        int newByteArrayLengthForMemoryControl = this.byteArrayLengthForMemoryControl;
        while ((long)newByteArrayLengthForMemoryControl * (long)this.size < this.totalByteArrayLength) {
            newByteArrayLengthForMemoryControl *= 2;
        }
        int newInternalTVListCapacity = SerializableRowRecordList.calculateCapacity(this.dataTypes, this.memoryLimitInMB, newByteArrayLengthForMemoryControl) / this.numCacheBlock;
        if (0 < newInternalTVListCapacity) {
            this.applyNewMemoryControlParameters(newByteArrayLengthForMemoryControl, newInternalTVListCapacity);
            return;
        }
        int delta = (int)((this.totalByteArrayLength - this.totalByteArrayLengthLimit) / (long)this.size / (long)this.indexListOfTextFields.length / (long)SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL);
        newByteArrayLengthForMemoryControl = this.byteArrayLengthForMemoryControl + 2 * (delta + 1) * SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL;
        newInternalTVListCapacity = SerializableRowRecordList.calculateCapacity(this.dataTypes, this.memoryLimitInMB, newByteArrayLengthForMemoryControl) / this.numCacheBlock;
        if (0 < newInternalTVListCapacity) {
            this.applyNewMemoryControlParameters(newByteArrayLengthForMemoryControl, newInternalTVListCapacity);
            return;
        }
        throw new QueryProcessException("Memory is not enough for current query.");
    }

    protected void applyNewMemoryControlParameters(int newByteArrayLengthForMemoryControl, int newInternalRowRecordListCapacity) throws IOException, QueryProcessException {
        int i;
        ElasticSerializableRowRecordList newElasticSerializableRowRecordList = new ElasticSerializableRowRecordList(this.dataTypes, this.queryId, this.memoryLimitInMB, newInternalRowRecordListCapacity, this.numCacheBlock);
        newElasticSerializableRowRecordList.evictionUpperBound = this.evictionUpperBound;
        int internalListEvictionUpperBound = this.evictionUpperBound / newInternalRowRecordListCapacity;
        for (i = 0; i < internalListEvictionUpperBound; ++i) {
            newElasticSerializableRowRecordList.rowRecordLists.add(null);
            newElasticSerializableRowRecordList.bitMaps.add(null);
        }
        for (i = newElasticSerializableRowRecordList.size = internalListEvictionUpperBound * newInternalRowRecordListCapacity; i < this.evictionUpperBound; ++i) {
            newElasticSerializableRowRecordList.put(null);
        }
        for (i = this.evictionUpperBound; i < this.size; ++i) {
            newElasticSerializableRowRecordList.put(this.getRowRecord(i), this.fieldsHasAnyNull(i));
        }
        this.internalRowRecordListCapacity = newInternalRowRecordListCapacity;
        this.cache = newElasticSerializableRowRecordList.cache;
        this.rowRecordLists = newElasticSerializableRowRecordList.rowRecordLists;
        this.bitMaps = newElasticSerializableRowRecordList.bitMaps;
        this.byteArrayLengthForMemoryControl = newByteArrayLengthForMemoryControl;
        this.totalByteArrayLengthLimit = (long)this.size * (long)this.indexListOfTextFields.length * (long)this.byteArrayLengthForMemoryControl;
    }

    public void setEvictionUpperBound(int evictionUpperBound) {
        this.evictionUpperBound = evictionUpperBound;
    }

    private class LRUCache
    extends Cache {
        LRUCache(int capacity) {
            super(capacity);
        }

        SerializableRowRecordList get(int targetIndex) throws IOException {
            if (!this.removeFirstOccurrence(targetIndex)) {
                if (this.cacheCapacity <= this.cacheSize) {
                    int lastIndex = this.removeLast();
                    if (lastIndex < ElasticSerializableRowRecordList.this.evictionUpperBound / ElasticSerializableRowRecordList.this.internalRowRecordListCapacity) {
                        ElasticSerializableRowRecordList.this.rowRecordLists.set(lastIndex, null);
                        ElasticSerializableRowRecordList.this.bitMaps.set(lastIndex, null);
                    } else {
                        ElasticSerializableRowRecordList.this.rowRecordLists.get(lastIndex).serialize();
                    }
                }
                ElasticSerializableRowRecordList.this.rowRecordLists.get(targetIndex).deserialize();
            }
            this.addFirst(targetIndex);
            return ElasticSerializableRowRecordList.this.rowRecordLists.get(targetIndex);
        }
    }
}

