/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.handler;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ResultColumn;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.protocol.influxdb.constant.InfluxSQLConstant;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunction;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionFactory;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionValue;
import org.apache.iotdb.db.protocol.influxdb.function.aggregator.InfluxAggregator;
import org.apache.iotdb.db.protocol.influxdb.function.selector.InfluxSelector;
import org.apache.iotdb.db.protocol.influxdb.meta.InfluxDBMetaManager;
import org.apache.iotdb.db.protocol.influxdb.operator.InfluxQueryOperator;
import org.apache.iotdb.db.protocol.influxdb.operator.InfluxSelectComponent;
import org.apache.iotdb.db.protocol.influxdb.util.FieldUtils;
import org.apache.iotdb.db.protocol.influxdb.util.FilterUtils;
import org.apache.iotdb.db.protocol.influxdb.util.JacksonUtils;
import org.apache.iotdb.db.protocol.influxdb.util.QueryResultUtils;
import org.apache.iotdb.db.protocol.influxdb.util.StringUtils;
import org.apache.iotdb.db.qp.constant.FilterConstant;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxQueryResultRsp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.influxdb.InfluxDBException;
import org.influxdb.dto.QueryResult;

public class QueryHandler {
    public static InfluxQueryResultRsp queryInfluxDB(String database, InfluxQueryOperator queryOperator, long sessionId, ServiceProvider serviceProvider) {
        String measurement = queryOperator.getFromComponent().getPrefixPaths().get(0).getFullPath();
        Map<String, Integer> fieldOrders = QueryHandler.getFieldOrders(database, measurement, serviceProvider);
        InfluxQueryResultRsp tsQueryResultRsp = new InfluxQueryResultRsp();
        try {
            QueryResult queryResult;
            if (queryOperator.getWhereComponent() != null || queryOperator.getSelectComponent().isHasCommonQuery() || queryOperator.getSelectComponent().isHasOnlyTraverseFunction()) {
                queryResult = QueryHandler.queryExpr(queryOperator.getWhereComponent() != null ? queryOperator.getWhereComponent().getFilterOperator() : null, database, measurement, serviceProvider, fieldOrders, sessionId);
                QueryHandler.ProcessSelectComponent(queryResult, queryOperator.getSelectComponent());
            } else {
                queryResult = QueryHandler.queryFuncWithoutFilter(queryOperator.getSelectComponent(), database, measurement, serviceProvider);
            }
            return tsQueryResultRsp.setResultJsonString(JacksonUtils.bean2Json(queryResult)).setStatus(RpcUtils.getInfluxDBStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        }
        catch (AuthException e) {
            return tsQueryResultRsp.setStatus(RpcUtils.getInfluxDBStatus((int)TSStatusCode.UNINITIALIZED_AUTH_ERROR.getStatusCode(), (String)e.getMessage()));
        }
    }

    public static IExpression getIExpressionForBasicFunctionOperator(BasicFunctionOperator basicFunctionOperator) {
        return new SingleSeriesExpression((Path)basicFunctionOperator.getSinglePath(), FilterUtils.filterTypeToFilter(basicFunctionOperator.getFilterType(), basicFunctionOperator.getValue()));
    }

    public static void ProcessSelectComponent(QueryResult queryResult, InfluxSelectComponent selectComponent) {
        List columns = ((QueryResult.Series)((QueryResult.Result)queryResult.getResults().get(0)).getSeries().get(0)).getColumns();
        HashMap columnOrders = new HashMap();
        for (int i = 0; i < columns.size(); ++i) {
            columnOrders.put(columns.get(i), i);
        }
        ArrayList values = ((QueryResult.Series)((QueryResult.Result)queryResult.getResults().get(0)).getSeries().get(0)).getValues();
        ArrayList<String> newColumns = new ArrayList<String>();
        newColumns.add("time");
        if (selectComponent.isHasFunction()) {
            ArrayList<InfluxFunction> functions = new ArrayList<InfluxFunction>();
            for (ResultColumn resultColumn : selectComponent.getResultColumns()) {
                Expression expression = resultColumn.getExpression();
                if (expression instanceof FunctionExpression) {
                    String functionName = ((FunctionExpression)expression).getFunctionName();
                    functions.add(InfluxFunctionFactory.generateFunction(functionName, expression.getExpressions()));
                    newColumns.add(functionName);
                    continue;
                }
                if (!(expression instanceof TimeSeriesOperand)) continue;
                String columnName = ((TimeSeriesOperand)expression).getPath().getFullPath();
                if (!columnName.equals("*")) {
                    newColumns.add(columnName);
                    continue;
                }
                newColumns.addAll(columns.subList(1, columns.size()));
            }
            for (List list : values) {
                for (InfluxFunction function : functions) {
                    List<Expression> expressions = function.getExpressions();
                    if (expressions == null) {
                        throw new IllegalArgumentException("not support param");
                    }
                    TimeSeriesOperand parmaExpression = (TimeSeriesOperand)expressions.get(0);
                    String parmaName = parmaExpression.getPath().getFullPath();
                    if (!columnOrders.containsKey(parmaName)) continue;
                    Object selectedValue = list.get((Integer)columnOrders.get(parmaName));
                    Long selectedTimestamp = (Long)list.get(0);
                    if (selectedValue == null) continue;
                    if (function instanceof InfluxSelector) {
                        ((InfluxSelector)function).updateValueAndRelateValues(new InfluxFunctionValue(selectedValue, selectedTimestamp), list);
                        continue;
                    }
                    ((InfluxAggregator)function).updateValueBruteForce(new InfluxFunctionValue(selectedValue, selectedTimestamp));
                }
            }
            ArrayList<Object> value = new ArrayList<Object>();
            values = new ArrayList();
            if (selectComponent.isHasCommonQuery()) {
                InfluxSelector influxSelector = (InfluxSelector)functions.get(0);
                List<Object> relatedValue = influxSelector.getRelatedValues();
                for (String column : newColumns) {
                    if (InfluxSQLConstant.getNativeSelectorFunctionNames().contains(column)) {
                        value.add(influxSelector.calculateBruteForce().getValue());
                        continue;
                    }
                    if (relatedValue == null) continue;
                    value.add(relatedValue.get((Integer)columnOrders.get(column)));
                }
            } else {
                for (InfluxFunction function : functions) {
                    if (value.size() == 0) {
                        value.add(function.calculateBruteForce().getTimestamp());
                    } else {
                        value.set(0, function.calculateBruteForce().getTimestamp());
                    }
                    value.add(function.calculateBruteForce().getValue());
                }
                if (selectComponent.isHasAggregationFunction() || selectComponent.isHasMoreFunction()) {
                    value.set(0, 0);
                }
            }
            values.add(value);
        } else if (selectComponent.isHasCommonQuery()) {
            for (ResultColumn resultColumn : selectComponent.getResultColumns()) {
                Expression expression = resultColumn.getExpression();
                if (!(expression instanceof TimeSeriesOperand)) continue;
                if (!((TimeSeriesOperand)expression).getPath().getFullPath().equals("*")) {
                    newColumns.add(((TimeSeriesOperand)expression).getPath().getFullPath());
                    continue;
                }
                newColumns.addAll(columns.subList(1, columns.size()));
            }
            ArrayList newValues = new ArrayList();
            for (List list : values) {
                ArrayList tmpValue = new ArrayList();
                for (String newColumn : newColumns) {
                    tmpValue.add(list.get((Integer)columnOrders.get(newColumn)));
                }
                newValues.add(tmpValue);
            }
            values = newValues;
        }
        QueryResultUtils.updateQueryResultColumnValue(queryResult, StringUtils.removeDuplicate(newColumns), values);
    }

    public static Map<String, Integer> getFieldOrders(String database, String measurement, ServiceProvider serviceProvider) {
        HashMap<String, Integer> fieldOrders = new HashMap<String, Integer>();
        long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
        try {
            String showTimeseriesSql = "show timeseries root." + database + '.' + measurement + ".**";
            PhysicalPlan physicalPlan = serviceProvider.getPlanner().parseSQLToPhysicalPlan(showTimeseriesSql);
            QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), showTimeseriesSql, 0L);
            QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, physicalPlan, 5000);
            int fieldNums = 0;
            Map<String, Integer> tagOrders = InfluxDBMetaManager.getTagOrders(database, measurement);
            int tagOrderNums = tagOrders.size();
            while (queryDataSet.hasNext()) {
                List fields = queryDataSet.next().getFields();
                String filed = StringUtils.getFieldByPath(((Field)fields.get(0)).getStringValue());
                if (fieldOrders.containsKey(filed)) continue;
                fieldOrders.put(filed, tagOrderNums + fieldNums + 1);
                ++fieldNums;
            }
        }
        catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
            throw new InfluxDBException(((Throwable)e).getMessage());
        }
        finally {
            ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
        }
        return fieldOrders;
    }

    public static QueryResult queryFuncWithoutFilter(InfluxSelectComponent selectComponent, String database, String measurement, ServiceProvider serviceProvider) {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("time");
        ArrayList<InfluxFunction> functions = new ArrayList<InfluxFunction>();
        String path = "root." + database + "." + measurement;
        for (ResultColumn resultColumn : selectComponent.getResultColumns()) {
            Expression expression = resultColumn.getExpression();
            if (!(expression instanceof FunctionExpression)) continue;
            String functionName = ((FunctionExpression)expression).getFunctionName();
            functions.add(InfluxFunctionFactory.generateFunction(functionName, expression.getExpressions()));
            columns.add(functionName);
        }
        ArrayList<Object> value = new ArrayList<Object>();
        ArrayList<ArrayList<Object>> values = new ArrayList<ArrayList<Object>>();
        for (InfluxFunction function : functions) {
            InfluxFunctionValue functionValue = QueryHandler.updateByIoTDBFunc(function, serviceProvider, path);
            if (value.size() == 0) {
                value.add(functionValue.getTimestamp());
            } else {
                value.set(0, functionValue.getTimestamp());
            }
            value.add(functionValue.getValue());
        }
        if (selectComponent.isHasAggregationFunction() || selectComponent.isHasMoreFunction()) {
            value.set(0, 0);
        }
        values.add(value);
        QueryResult queryResult = new QueryResult();
        QueryResult.Series series = new QueryResult.Series();
        series.setColumns(columns);
        series.setValues(values);
        series.setName(measurement);
        QueryResult.Result result = new QueryResult.Result();
        result.setSeries(new ArrayList<QueryResult.Series>(Arrays.asList(series)));
        queryResult.setResults(new ArrayList<QueryResult.Result>(Arrays.asList(result)));
        return queryResult;
    }

    private static InfluxFunctionValue updateByIoTDBFunc(InfluxFunction function, ServiceProvider serviceProvider, String path) {
        switch (function.getFunctionName()) {
            case "count": {
                long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
                String functionSql = StringUtils.generateFunctionSql(function.getFunctionName(), function.getParmaName(), path);
                try {
                    QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(functionSql);
                    QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), functionSql, 0L);
                    QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
                    while (queryDataSet.hasNext()) {
                        List fields = queryDataSet.next().getFields();
                        for (Field field : fields) {
                            function.updateValueIoTDBFunc(new InfluxFunctionValue(field.getLongV(), null));
                        }
                    }
                    break;
                }
                catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
                    ((Throwable)e).printStackTrace();
                    throw new InfluxDBException(((Throwable)e).getMessage());
                }
                finally {
                    ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
                }
            }
            case "mean": {
                long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
                try {
                    String functionSqlCount = StringUtils.generateFunctionSql("count", function.getParmaName(), path);
                    QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(functionSqlCount);
                    QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), functionSqlCount, 0L);
                    QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
                    while (queryDataSet.hasNext()) {
                        List fields = queryDataSet.next().getFields();
                        for (Field field : fields) {
                            function.updateValueIoTDBFunc(new InfluxFunctionValue(field.getLongV(), null));
                        }
                    }
                }
                catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
                    throw new InfluxDBException(((Throwable)e).getMessage());
                }
                finally {
                    ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
                }
                long queryId1 = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
                try {
                    String functionSqlSum = StringUtils.generateFunctionSql("sum", function.getParmaName(), path);
                    QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(functionSqlSum);
                    QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), functionSqlSum, 0L);
                    QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
                    while (queryDataSet.hasNext()) {
                        List fields = queryDataSet.next().getFields();
                        for (Field field : fields) {
                            function.updateValueIoTDBFunc(null, new InfluxFunctionValue(field.getDoubleV(), null));
                        }
                    }
                    break;
                }
                catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
                    ((Throwable)e).printStackTrace();
                    throw new InfluxDBException(((Throwable)e).getMessage());
                }
                finally {
                    ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId1);
                }
            }
            case "spread": {
                long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
                try {
                    String functionSqlMaxValue = StringUtils.generateFunctionSql("max_value", function.getParmaName(), path);
                    QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(functionSqlMaxValue);
                    QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), functionSqlMaxValue, 0L);
                    QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
                    while (queryDataSet.hasNext()) {
                        List paths = queryDataSet.getPaths();
                        List fields = queryDataSet.next().getFields();
                        for (int i = 0; i < paths.size(); ++i) {
                            Object o = FieldUtils.iotdbFieldConvert((Field)fields.get(i));
                            if (!(o instanceof Number)) continue;
                            function.updateValueIoTDBFunc(new InfluxFunctionValue(((Number)o).doubleValue(), null));
                        }
                    }
                }
                catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
                    throw new InfluxDBException(((Throwable)e).getMessage());
                }
                finally {
                    ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
                }
                long queryId1 = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
                try {
                    String functionSqlMinValue = StringUtils.generateFunctionSql("min_value", function.getParmaName(), path);
                    QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(functionSqlMinValue);
                    QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), functionSqlMinValue, 0L);
                    QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
                    while (queryDataSet.hasNext()) {
                        List paths = queryDataSet.getPaths();
                        List fields = queryDataSet.next().getFields();
                        for (int i = 0; i < paths.size(); ++i) {
                            Object o = FieldUtils.iotdbFieldConvert((Field)fields.get(i));
                            if (!(o instanceof Number)) continue;
                            function.updateValueIoTDBFunc(null, new InfluxFunctionValue(((Number)o).doubleValue(), null));
                        }
                    }
                    break;
                }
                catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
                    throw new InfluxDBException(((Throwable)e).getMessage());
                }
                finally {
                    ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId1);
                }
            }
            case "sum": {
                long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
                try {
                    String functionSql = StringUtils.generateFunctionSql("sum", function.getParmaName(), path);
                    QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(functionSql);
                    QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), functionSql, 0L);
                    QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
                    while (queryDataSet.hasNext()) {
                        List fields = queryDataSet.next().getFields();
                        if (((Field)fields.get(1)).getDataType() == null) continue;
                        function.updateValueIoTDBFunc(new InfluxFunctionValue(((Field)fields.get(1)).getDoubleV(), null));
                    }
                    break;
                }
                catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
                    throw new InfluxDBException(((Throwable)e).getMessage());
                }
                finally {
                    ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
                }
            }
            case "first": 
            case "last": {
                String functionSql = function.getFunctionName().equals("first") ? StringUtils.generateFunctionSql("first_value", function.getParmaName(), path) : StringUtils.generateFunctionSql("last_value", function.getParmaName(), path);
                ArrayList<Long> queryIds = new ArrayList<Long>();
                queryIds.add(ServiceProvider.SESSION_MANAGER.requestQueryId(true));
                try {
                    QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(functionSql);
                    QueryContext queryContext = serviceProvider.genQueryContext((Long)queryIds.get(0), true, System.currentTimeMillis(), functionSql, 0L);
                    QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
                    while (queryDataSet.hasNext()) {
                        List paths = queryDataSet.getPaths();
                        List fields = queryDataSet.next().getFields();
                        for (int i = 0; i < paths.size(); ++i) {
                            Object o = FieldUtils.iotdbFieldConvert((Field)fields.get(i));
                            long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
                            queryIds.add(queryId);
                            if (o == null) continue;
                            String specificSql = String.format("select %s from %s where %s=%s", function.getParmaName(), ((Path)paths.get(i)).getDevice(), ((Path)paths.get(i)).getFullPath(), o);
                            QueryPlan queryPlanNew = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(specificSql);
                            QueryContext queryContextNew = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), specificSql, 0L);
                            QueryDataSet queryDataSetNew = serviceProvider.createQueryDataSet(queryContextNew, queryPlanNew, 5000);
                            while (queryDataSetNew.hasNext()) {
                                RowRecord recordNew = queryDataSetNew.next();
                                List newFields = recordNew.getFields();
                                long time = recordNew.getTimestamp();
                                function.updateValueIoTDBFunc(new InfluxFunctionValue(newFields.get(0), time));
                            }
                        }
                    }
                }
                catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
                    throw new InfluxDBException(((Throwable)e).getMessage());
                }
                finally {
                    Iterator iterator = queryIds.iterator();
                    while (iterator.hasNext()) {
                        long queryId = (Long)iterator.next();
                        ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
                    }
                }
            }
            case "max": 
            case "min": {
                String functionSql = function.getFunctionName().equals("max") ? StringUtils.generateFunctionSql("max_value", function.getParmaName(), path) : StringUtils.generateFunctionSql("min_value", function.getParmaName(), path);
                long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
                try {
                    QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(functionSql);
                    QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), functionSql, 0L);
                    QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
                    while (queryDataSet.hasNext()) {
                        List paths = queryDataSet.getPaths();
                        List fields = queryDataSet.next().getFields();
                        for (int i = 0; i < paths.size(); ++i) {
                            Object o = FieldUtils.iotdbFieldConvert((Field)fields.get(i));
                            function.updateValueIoTDBFunc(new InfluxFunctionValue(o, null));
                        }
                    }
                    break;
                }
                catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
                    throw new InfluxDBException(((Throwable)e).getMessage());
                }
                finally {
                    ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
                }
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + function.getFunctionName());
            }
        }
        return function.calculateByIoTDBFunc();
    }

    public static void checkInfluxDBQueryOperator(Operator operator) {
        if (!(operator instanceof InfluxQueryOperator)) {
            throw new IllegalArgumentException("not query sql");
        }
        InfluxSelectComponent selectComponent = ((InfluxQueryOperator)operator).getSelectComponent();
        if (selectComponent.isHasMoreSelectorFunction() && selectComponent.isHasCommonQuery()) {
            throw new IllegalArgumentException("ERR: mixing multiple selector functions with tags or fields is not supported");
        }
        if (selectComponent.isHasAggregationFunction() && selectComponent.isHasCommonQuery()) {
            throw new IllegalArgumentException("ERR: mixing aggregate and non-aggregate queries is not supported");
        }
    }

    public static QueryResult queryExpr(FilterOperator operator, String database, String measurement, ServiceProvider serviceProvider, Map<String, Integer> fieldOrders, Long sessionId) throws AuthException {
        if (operator == null) {
            ArrayList<IExpression> expressions = new ArrayList<IExpression>();
            return QueryHandler.queryByConditions(expressions, database, measurement, serviceProvider, fieldOrders, sessionId);
        }
        if (operator instanceof BasicFunctionOperator) {
            ArrayList<IExpression> iExpressions = new ArrayList<IExpression>();
            iExpressions.add(QueryHandler.getIExpressionForBasicFunctionOperator((BasicFunctionOperator)operator));
            return QueryHandler.queryByConditions(iExpressions, database, measurement, serviceProvider, fieldOrders, sessionId);
        }
        FilterOperator leftOperator = operator.getChildren().get(0);
        FilterOperator rightOperator = operator.getChildren().get(1);
        if (operator.getFilterType() == FilterConstant.FilterType.KW_OR) {
            return QueryResultUtils.orQueryResultProcess(QueryHandler.queryExpr(leftOperator, database, measurement, serviceProvider, fieldOrders, sessionId), QueryHandler.queryExpr(rightOperator, database, measurement, serviceProvider, fieldOrders, sessionId));
        }
        if (operator.getFilterType() == FilterConstant.FilterType.KW_AND) {
            if (QueryHandler.canMergeOperator(leftOperator) && QueryHandler.canMergeOperator(rightOperator)) {
                List<IExpression> iExpressions1 = QueryHandler.getIExpressionByFilterOperatorOperator(leftOperator);
                List<IExpression> iExpressions2 = QueryHandler.getIExpressionByFilterOperatorOperator(rightOperator);
                iExpressions1.addAll(iExpressions2);
                return QueryHandler.queryByConditions(iExpressions1, database, measurement, serviceProvider, fieldOrders, sessionId);
            }
            return QueryResultUtils.andQueryResultProcess(QueryHandler.queryExpr(leftOperator, database, measurement, serviceProvider, fieldOrders, sessionId), QueryHandler.queryExpr(rightOperator, database, measurement, serviceProvider, fieldOrders, sessionId));
        }
        throw new IllegalArgumentException("unknown operator " + operator);
    }

    private static QueryResult queryByConditions(List<IExpression> expressions, String database, String measurement, ServiceProvider serviceProvider, Map<String, Integer> fieldOrders, Long sessionId) throws AuthException {
        HashMap<Integer, SingleSeriesExpression> realTagOrders = new HashMap<Integer, SingleSeriesExpression>();
        ArrayList<SingleSeriesExpression> fieldExpressions = new ArrayList<SingleSeriesExpression>();
        int currentQueryMaxTagNum = 0;
        Map<String, Integer> tagOrders = InfluxDBMetaManager.getTagOrders(database, measurement);
        for (IExpression expression : expressions) {
            SingleSeriesExpression singleSeriesExpression = (SingleSeriesExpression)expression;
            if (tagOrders.containsKey(singleSeriesExpression.getSeriesPath().getFullPath())) {
                int curOrder = tagOrders.get(singleSeriesExpression.getSeriesPath().getFullPath());
                realTagOrders.put(curOrder, singleSeriesExpression);
                currentQueryMaxTagNum = Math.max(currentQueryMaxTagNum, curOrder);
                continue;
            }
            fieldExpressions.add(singleSeriesExpression);
        }
        StringBuilder curQueryPath = new StringBuilder("root." + database + "." + measurement);
        for (int i = 1; i <= currentQueryMaxTagNum; ++i) {
            if (realTagOrders.containsKey(i)) {
                curQueryPath.append(".").append(StringUtils.removeQuotation(FilterUtils.getFilterStringValue(((SingleSeriesExpression)realTagOrders.get(i)).getFilter())));
                continue;
            }
            curQueryPath.append(".").append("*");
        }
        curQueryPath.append(".**");
        StringBuilder realIotDBCondition = new StringBuilder();
        for (int i = 0; i < fieldExpressions.size(); ++i) {
            SingleSeriesExpression singleSeriesExpression = (SingleSeriesExpression)fieldExpressions.get(i);
            if (i != 0) {
                realIotDBCondition.append(" and ");
            }
            realIotDBCondition.append(singleSeriesExpression.getSeriesPath().getFullPath()).append(" ").append(FilterUtils.getFilerSymbol(singleSeriesExpression.getFilter())).append(" ").append(FilterUtils.getFilterStringValue(singleSeriesExpression.getFilter()));
        }
        String realQuerySql = "select * from " + curQueryPath;
        if (realIotDBCondition.length() != 0) {
            realQuerySql = realQuerySql + " where " + realIotDBCondition;
        }
        realQuerySql = realQuerySql + " align by device";
        long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
        try {
            QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(realQuerySql);
            TSStatus tsStatus = SessionManager.getInstance().checkAuthority(queryPlan, sessionId);
            if (tsStatus != null) {
                throw new AuthException(tsStatus.getMessage());
            }
            QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), realQuerySql, 0L);
            QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
            QueryResult queryResult = QueryResultUtils.iotdbResultConvertInfluxResult(queryDataSet, database, measurement, fieldOrders);
            return queryResult;
        }
        catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
            throw new InfluxDBException(((Throwable)e).getMessage());
        }
        finally {
            ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
        }
    }

    public static List<IExpression> getIExpressionByFilterOperatorOperator(FilterOperator filterOperator) {
        if (filterOperator instanceof BasicFunctionOperator) {
            ArrayList<IExpression> expressions = new ArrayList<IExpression>();
            expressions.add(QueryHandler.getIExpressionForBasicFunctionOperator((BasicFunctionOperator)filterOperator));
            return expressions;
        }
        FilterOperator leftOperator = filterOperator.getChildren().get(0);
        FilterOperator rightOperator = filterOperator.getChildren().get(1);
        List<IExpression> expressions1 = QueryHandler.getIExpressionByFilterOperatorOperator(leftOperator);
        List<IExpression> expressions2 = QueryHandler.getIExpressionByFilterOperatorOperator(rightOperator);
        expressions1.addAll(expressions2);
        return expressions1;
    }

    public static boolean canMergeOperator(FilterOperator operator) {
        if (operator instanceof BasicFunctionOperator) {
            return true;
        }
        if (operator.getFilterType() == FilterConstant.FilterType.KW_OR) {
            return false;
        }
        FilterOperator leftOperator = operator.getChildren().get(0);
        FilterOperator rightOperator = operator.getChildren().get(1);
        return QueryHandler.canMergeOperator(leftOperator) && QueryHandler.canMergeOperator(rightOperator);
    }
}

