/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.CreatePipeSinkPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class CreatePipeSinkOperator
extends Operator {
    private String pipeSinkName;
    private String pipeSinkType;
    private Map<String, String> pipeSinkAttributes;

    public CreatePipeSinkOperator(String pipeSinkName, String pipeSinkType) {
        super(200);
        this.pipeSinkName = pipeSinkName;
        this.pipeSinkType = pipeSinkType;
        this.pipeSinkAttributes = new HashMap<String, String>();
        this.operatorType = Operator.OperatorType.CREATE_PIPESINK;
    }

    public void setPipeSinkAttributes(Map<String, String> pipeSinkAttributes) {
        this.pipeSinkAttributes = pipeSinkAttributes;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        CreatePipeSinkPlan plan = new CreatePipeSinkPlan(this.pipeSinkName, this.pipeSinkType);
        for (Map.Entry<String, String> entry : this.pipeSinkAttributes.entrySet()) {
            plan.addPipeSinkAttribute(entry.getKey(), entry.getValue());
        }
        return plan;
    }
}

