/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowContinuousQueriesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowQueryProcesslistPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTemplatesPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class ShowOperator
extends Operator {
    public ShowOperator(int tokenIntType) {
        this(tokenIntType, Operator.OperatorType.SHOW);
    }

    public ShowOperator(int tokenIntType, Operator.OperatorType operatorType) {
        super(tokenIntType);
        this.operatorType = operatorType;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        switch (this.tokenIntType) {
            case 67: {
                return new ShowPlan(ShowPlan.ShowContentType.FLUSH_TASK_INFO);
            }
            case 72: {
                return new ShowPlan(ShowPlan.ShowContentType.VERSION);
            }
            case 97: {
                return new ShowQueryProcesslistPlan(ShowPlan.ShowContentType.QUERY_PROCESSLIST);
            }
            case 108: {
                return new ShowContinuousQueriesPlan();
            }
            case 119: {
                return new ShowTemplatesPlan();
            }
        }
        throw new LogicalOperatorException(String.format("not supported operator type %s in show operation.", new Object[]{this.operatorType}));
    }
}

