/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateAlignedTimeSeriesPlan
extends PhysicalPlan {
    private static final Logger logger = LoggerFactory.getLogger(CreateAlignedTimeSeriesPlan.class);
    private static final int PLAN_SINCE_0_14 = -1;
    private PartialPath prefixPath;
    private List<String> measurements;
    private List<TSDataType> dataTypes;
    private List<TSEncoding> encodings;
    private List<CompressionType> compressors;
    private List<String> aliasList;
    private List<Map<String, String>> tagsList;
    private List<Map<String, String>> attributesList;
    private List<Long> tagOffsets = null;

    public CreateAlignedTimeSeriesPlan() {
        super(Operator.OperatorType.CREATE_ALIGNED_TIMESERIES);
        this.canBeSplit = false;
    }

    public CreateAlignedTimeSeriesPlan(PartialPath prefixPath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> aliasList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList) {
        super(Operator.OperatorType.CREATE_ALIGNED_TIMESERIES);
        this.prefixPath = prefixPath;
        this.measurements = measurements;
        this.dataTypes = dataTypes;
        this.encodings = encodings;
        this.compressors = compressors;
        this.aliasList = aliasList;
        this.tagsList = tagsList;
        this.attributesList = attributesList;
        this.canBeSplit = false;
    }

    public CreateAlignedTimeSeriesPlan(PartialPath prefixPath, String measurement, MeasurementSchema schema) {
        super(Operator.OperatorType.CREATE_ALIGNED_TIMESERIES);
        this.prefixPath = prefixPath;
        this.measurements = Collections.singletonList(measurement);
        this.dataTypes = Collections.singletonList(schema.getType());
        this.encodings = Collections.singletonList(schema.getEncodingType());
        this.compressors = Collections.singletonList(schema.getCompressor());
        this.canBeSplit = false;
    }

    public PartialPath getPrefixPath() {
        return this.prefixPath;
    }

    public void setPrefixPath(PartialPath prefixPath) {
        this.prefixPath = prefixPath;
    }

    public List<String> getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(List<String> measurements) {
        this.measurements = measurements;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public List<TSEncoding> getEncodings() {
        return this.encodings;
    }

    public void setEncodings(List<TSEncoding> encodings) {
        this.encodings = encodings;
    }

    public List<CompressionType> getCompressors() {
        return this.compressors;
    }

    public void setCompressors(List<CompressionType> compressors) {
        this.compressors = compressors;
    }

    public List<String> getAliasList() {
        return this.aliasList;
    }

    public void setAliasList(List<String> aliasList) {
        this.aliasList = aliasList;
    }

    public List<Map<String, String>> getTagsList() {
        return this.tagsList;
    }

    public void setTagsList(List<Map<String, String>> tagsList) {
        this.tagsList = tagsList;
    }

    public List<Map<String, String>> getAttributesList() {
        return this.attributesList;
    }

    public void setAttributesList(List<Map<String, String>> attributesList) {
        this.attributesList = attributesList;
    }

    public List<Long> getTagOffsets() {
        if (this.tagOffsets == null) {
            this.tagOffsets = new ArrayList<Long>();
            for (int i = 0; i < this.measurements.size(); ++i) {
                this.tagOffsets.add(Long.parseLong("-1"));
            }
        }
        return this.tagOffsets;
    }

    public void setTagOffsets(List<Long> tagOffsets) {
        this.tagOffsets = tagOffsets;
    }

    public String toString() {
        return String.format("devicePath: %s, measurements: %s, dataTypes: %s, encodings: %s, compressions: %s, tagOffsets: %s", this.prefixPath, this.measurements, this.dataTypes, this.encodings, this.compressors, this.tagOffsets);
    }

    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        for (String measurement : this.measurements) {
            try {
                paths.add(new PartialPath(this.prefixPath.getFullPath(), measurement));
            }
            catch (IllegalPathException e) {
                logger.error("Failed to get paths of CreateAlignedTimeSeriesPlan. ", (Throwable)e);
            }
        }
        return paths;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.CREATE_ALIGNED_TIMESERIES.ordinal());
        stream.writeInt(-1);
        byte[] bytes = this.prefixPath.getFullPath().getBytes();
        stream.writeInt(bytes.length);
        stream.write(bytes);
        ReadWriteIOUtils.write((int)this.measurements.size(), (OutputStream)stream);
        for (String string : this.measurements) {
            ReadWriteIOUtils.write((String)string, (OutputStream)stream);
        }
        for (TSDataType tSDataType : this.dataTypes) {
            stream.write(tSDataType.ordinal());
        }
        for (TSEncoding tSEncoding : this.encodings) {
            stream.write(tSEncoding.ordinal());
        }
        for (CompressionType compressionType : this.compressors) {
            stream.write(compressionType.ordinal());
        }
        if (this.tagOffsets == null) {
            this.tagOffsets = new ArrayList<Long>();
            for (int i = 0; i < this.measurements.size(); ++i) {
                this.tagOffsets.add(Long.parseLong("-1"));
            }
        }
        for (Long l : this.tagOffsets) {
            stream.writeLong(l);
        }
        if (this.aliasList != null && !this.aliasList.isEmpty()) {
            stream.write(1);
            for (String string : this.aliasList) {
                ReadWriteIOUtils.write((String)string, (OutputStream)stream);
            }
        } else {
            stream.write(0);
        }
        if (this.tagsList != null && !this.tagsList.isEmpty()) {
            stream.write(1);
            for (Map map : this.tagsList) {
                ReadWriteIOUtils.write((Map)map, (OutputStream)stream);
            }
        } else {
            stream.write(0);
        }
        if (this.attributesList != null && !this.attributesList.isEmpty()) {
            stream.write(1);
            for (Map map : this.attributesList) {
                ReadWriteIOUtils.write((Map)map, (OutputStream)stream);
            }
        } else {
            stream.write(0);
        }
        stream.writeLong(this.index);
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.CREATE_ALIGNED_TIMESERIES.ordinal());
        buffer.putInt(-1);
        byte[] bytes = this.prefixPath.getFullPath().getBytes();
        buffer.putInt(bytes.length);
        buffer.put(bytes);
        ReadWriteIOUtils.write((int)this.measurements.size(), (ByteBuffer)buffer);
        for (String string : this.measurements) {
            ReadWriteIOUtils.write((String)string, (ByteBuffer)buffer);
        }
        for (TSDataType tSDataType : this.dataTypes) {
            buffer.put((byte)tSDataType.ordinal());
        }
        for (TSEncoding tSEncoding : this.encodings) {
            buffer.put((byte)tSEncoding.ordinal());
        }
        for (CompressionType compressionType : this.compressors) {
            buffer.put((byte)compressionType.ordinal());
        }
        for (Long l : this.getTagOffsets()) {
            buffer.putLong(l);
        }
        if (this.aliasList != null && !this.aliasList.isEmpty()) {
            buffer.put((byte)1);
            for (String string : this.aliasList) {
                ReadWriteIOUtils.write((String)string, (ByteBuffer)buffer);
            }
        } else {
            buffer.put((byte)0);
        }
        if (this.tagsList != null && !this.tagsList.isEmpty()) {
            buffer.put((byte)1);
            for (Map map : this.tagsList) {
                ReadWriteIOUtils.write((Map)map, (ByteBuffer)buffer);
            }
        } else {
            buffer.put((byte)0);
        }
        if (this.attributesList != null && !this.attributesList.isEmpty()) {
            buffer.put((byte)1);
            for (Map map : this.attributesList) {
                ReadWriteIOUtils.write((Map)map, (ByteBuffer)buffer);
            }
        } else {
            buffer.put((byte)0);
        }
        buffer.putLong(this.index);
    }

    public void formerSerialize(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.CREATE_ALIGNED_TIMESERIES.ordinal());
        byte[] bytes = this.prefixPath.getFullPath().getBytes();
        buffer.putInt(bytes.length);
        buffer.put(bytes);
        ReadWriteIOUtils.write((int)this.measurements.size(), (ByteBuffer)buffer);
        for (String measurement : this.measurements) {
            ReadWriteIOUtils.write((String)measurement, (ByteBuffer)buffer);
        }
        for (TSDataType dataType : this.dataTypes) {
            buffer.put((byte)dataType.ordinal());
        }
        for (TSEncoding encoding : this.encodings) {
            buffer.put((byte)encoding.ordinal());
        }
        for (CompressionType compressor : this.compressors) {
            buffer.put((byte)compressor.ordinal());
        }
        if (this.aliasList != null && !this.aliasList.isEmpty()) {
            buffer.put((byte)1);
            for (String alias : this.aliasList) {
                ReadWriteIOUtils.write((String)alias, (ByteBuffer)buffer);
            }
        } else {
            buffer.put((byte)0);
        }
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        int i;
        int length = buffer.getInt();
        boolean isOldVersion = true;
        if (length == -1) {
            length = buffer.getInt();
            isOldVersion = false;
        }
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        this.prefixPath = new PartialPath(new String(bytes));
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.measurements = new ArrayList<String>();
        for (i = 0; i < size; ++i) {
            this.measurements.add(ReadWriteIOUtils.readString((ByteBuffer)buffer));
        }
        this.dataTypes = new ArrayList<TSDataType>();
        for (i = 0; i < size; ++i) {
            this.dataTypes.add(TSDataType.values()[buffer.get()]);
        }
        this.encodings = new ArrayList<TSEncoding>();
        for (i = 0; i < size; ++i) {
            this.encodings.add(TSEncoding.values()[buffer.get()]);
        }
        this.compressors = new ArrayList<CompressionType>();
        for (i = 0; i < size; ++i) {
            this.compressors.add(CompressionType.values()[buffer.get()]);
        }
        if (!isOldVersion) {
            this.tagOffsets = new ArrayList<Long>();
            for (i = 0; i < size; ++i) {
                this.tagOffsets.add(buffer.getLong());
            }
        }
        if (buffer.get() == 1) {
            this.aliasList = new ArrayList<String>();
            for (i = 0; i < size; ++i) {
                this.aliasList.add(ReadWriteIOUtils.readString((ByteBuffer)buffer));
            }
        }
        if (!isOldVersion) {
            if (buffer.get() == 1) {
                this.tagsList = new ArrayList<Map<String, String>>();
                for (i = 0; i < size; ++i) {
                    this.tagsList.add(ReadWriteIOUtils.readMap((ByteBuffer)buffer));
                }
            }
            if (buffer.get() == 1) {
                this.attributesList = new ArrayList<Map<String, String>>();
                for (i = 0; i < size; ++i) {
                    this.attributesList.add(ReadWriteIOUtils.readMap((ByteBuffer)buffer));
                }
            }
        }
        this.index = buffer.getLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAlignedTimeSeriesPlan that = (CreateAlignedTimeSeriesPlan)o;
        return Objects.equals(this.prefixPath, that.prefixPath) && Objects.equals(this.measurements, that.measurements) && Objects.equals(this.dataTypes, that.dataTypes) && Objects.equals(this.encodings, that.encodings) && Objects.equals(this.compressors, that.compressors) && Objects.equals(this.tagOffsets, that.tagOffsets);
    }

    public int hashCode() {
        return Objects.hash(this.prefixPath, this.measurements, this.dataTypes, this.encodings, this.compressors, this.tagOffsets);
    }
}

