/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.trigger.executor.TriggerEvent;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class CreateTriggerPlan
extends PhysicalPlan {
    private String triggerName;
    private TriggerEvent event;
    private PartialPath fullPath;
    private String className;
    private Map<String, String> attributes;
    private boolean isStopped = false;

    public CreateTriggerPlan() {
        super(Operator.OperatorType.CREATE_TRIGGER);
        this.canBeSplit = false;
    }

    public CreateTriggerPlan(String triggerName, TriggerEvent event, PartialPath fullPath, String className, Map<String, String> attributes) {
        super(Operator.OperatorType.CREATE_TRIGGER);
        this.triggerName = triggerName;
        this.event = event;
        this.fullPath = fullPath;
        this.className = className;
        this.attributes = attributes;
        this.canBeSplit = false;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public TriggerEvent getEvent() {
        return this.event;
    }

    public PartialPath getFullPath() {
        return this.fullPath;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void markAsStarted() {
        this.isStopped = false;
    }

    public void markAsStopped() {
        this.isStopped = true;
    }

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.CREATE_TRIGGER.ordinal());
        this.putString(stream, this.triggerName);
        stream.write(this.event.getId());
        this.putString(stream, this.fullPath.getFullPath());
        this.putString(stream, this.className);
        stream.writeInt(this.attributes.size());
        for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
            this.putString(stream, attribute.getKey());
            this.putString(stream, attribute.getValue());
        }
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.CREATE_TRIGGER.ordinal());
        this.putString(buffer, this.triggerName);
        buffer.put(this.event.getId());
        this.putString(buffer, this.fullPath.getFullPath());
        this.putString(buffer, this.className);
        buffer.putInt(this.attributes.size());
        for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
            this.putString(buffer, attribute.getKey());
            this.putString(buffer, attribute.getValue());
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.triggerName = this.readString(buffer);
        this.event = TriggerEvent.construct(buffer.get());
        this.fullPath = new PartialPath(this.readString(buffer));
        this.className = this.readString(buffer);
        this.attributes = new HashMap<String, String>();
        int attributeNumber = buffer.getInt();
        for (int i = 0; i < attributeNumber; ++i) {
            String key = this.readString(buffer);
            String value = this.readString(buffer);
            this.attributes.put(key, value);
        }
    }

    @Override
    public List<? extends PartialPath> getAuthPaths() {
        return Collections.singletonList(this.fullPath);
    }
}

