/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SetTemplatePlan
extends PhysicalPlan {
    String templateName;
    String prefixPath;

    public SetTemplatePlan() {
        super(Operator.OperatorType.SET_TEMPLATE);
    }

    public SetTemplatePlan(String templateName, String prefixPath) throws IllegalPathException {
        super(Operator.OperatorType.SET_TEMPLATE);
        String[] pathNodes;
        for (String s : pathNodes = PathUtils.splitPathToDetachedNodes((String)prefixPath)) {
            if (!s.equals("*") && !s.equals("**")) continue;
            throw new IllegalPathException(prefixPath, "template cannot be set on a path with wildcard.");
        }
        this.templateName = templateName;
        this.prefixPath = prefixPath;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getPrefixPath() {
        return this.prefixPath;
    }

    public void setPrefixPath(String prefixPath) {
        this.prefixPath = prefixPath;
    }

    public List<PartialPath> getPaths() {
        return null;
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.SET_TEMPLATE.ordinal());
        ReadWriteIOUtils.write((String)this.templateName, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((String)this.prefixPath, (ByteBuffer)buffer);
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.templateName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.prefixPath = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.index = buffer.getLong();
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.SET_TEMPLATE.ordinal());
        ReadWriteIOUtils.write((String)this.templateName, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.prefixPath, (OutputStream)stream);
        stream.writeLong(this.index);
    }
}

