/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class ShowPlan
extends PhysicalPlan {
    private ShowContentType showContentType;
    protected int limit = 0;
    protected int offset = 0;
    protected PartialPath path;
    private boolean hasLimit;

    public ShowPlan(ShowContentType showContentType) {
        super(Operator.OperatorType.SHOW);
        this.setQuery(true);
        this.showContentType = showContentType;
    }

    public ShowPlan(ShowContentType showContentType, PartialPath path) {
        this(showContentType);
        this.path = path;
    }

    public ShowPlan(ShowContentType showContentType, PartialPath path, int limit, int offset) {
        this(showContentType, path);
        this.limit = limit;
        this.offset = offset;
        this.hasLimit = limit != 0;
    }

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    public ShowContentType getShowContentType() {
        return this.showContentType;
    }

    public PartialPath getPath() {
        return this.path;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean hasLimit() {
        return this.hasLimit;
    }

    public void setHasLimit(boolean hasLimit) {
        this.hasLimit = hasLimit;
    }

    public String toString() {
        return String.format("%s %s", new Object[]{this.getOperatorType(), this.showContentType});
    }

    @Override
    public String getOperatorName() {
        return String.format("%s: %s", new Object[]{this.getOperatorType(), this.showContentType});
    }

    public static enum ShowContentType {
        FLUSH_TASK_INFO,
        TTL,
        VERSION,
        TIMESERIES,
        STORAGE_GROUP,
        CHILD_PATH,
        CHILD_NODE,
        DEVICES,
        COUNT_TIMESERIES,
        COUNT_NODE_TIMESERIES,
        COUNT_NODES,
        FUNCTIONS,
        COUNT_DEVICES,
        COUNT_STORAGE_GROUP,
        QUERY_PROCESSLIST,
        TRIGGERS,
        LOCK_INFO,
        CONTINUOUS_QUERY,
        QUERY_RESOURCE,
        SCHEMA_TEMPLATE,
        NODES_IN_SCHEMA_TEMPLATE,
        PATHS_SET_SCHEMA_TEMPLATE,
        PATHS_USING_SCHEMA_TEMPLATE,
        PIPESINK,
        PIPESINKTYPE,
        PIPE,
        PIPESERVER;

    }
}

