/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.Serializable;
import org.apache.iotdb.db.query.aggregation.impl.LastValueAggrResult;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.utils.ValueIterator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.IBatchDataIterator;

public class LastValueDescAggrResult
extends LastValueAggrResult {
    public LastValueDescAggrResult(TSDataType dataType) {
        super(dataType);
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        if (this.hasFinalResult()) {
            return;
        }
        Serializable lastVal = statistics.getLastValue();
        this.setValue(lastVal);
        this.timestamp = statistics.getEndTime();
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator, long minBound, long maxBound) {
        if (this.hasFinalResult()) {
            return;
        }
        long time = Long.MIN_VALUE;
        Object lastVal = null;
        if (batchIterator.hasNext(minBound, maxBound) && batchIterator.currentTime() < maxBound && batchIterator.currentTime() >= minBound) {
            time = batchIterator.currentTime();
            lastVal = batchIterator.currentValue();
            batchIterator.next();
        }
        if (time != Long.MIN_VALUE) {
            this.setValue(lastVal);
            this.timestamp = time;
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        int timeLength;
        if (this.hasFinalResult()) {
            return;
        }
        long[] timesForFirstValue = new long[100];
        for (int currentPos = 0; currentPos < length; currentPos += timeLength) {
            timeLength = Math.min(length - currentPos, 100);
            System.arraycopy(timestamps, currentPos, timesForFirstValue, 0, timeLength);
            Object[] values = dataReader.getValuesInTimestamps(timesForFirstValue, timeLength);
            for (int i = 0; i < timeLength; ++i) {
                if (values[i] == null) continue;
                this.setValue(values[i]);
                this.timestamp = timesForFirstValue[i];
                return;
            }
        }
    }

    @Override
    public void updateResultUsingValues(long[] timestamps, int length, ValueIterator valueIterator) {
        if (this.hasFinalResult()) {
            return;
        }
        if (valueIterator.hasNext()) {
            this.timestamp = timestamps[valueIterator.getCurPos()];
            this.setValue(valueIterator.next());
        }
    }

    @Override
    public boolean hasFinalResult() {
        return this.hasCandidateResult;
    }

    @Override
    public boolean isAscending() {
        return false;
    }
}

