/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.utils.ValueIterator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.IBatchDataIterator;

public class MaxTimeAggrResult
extends AggregateResult {
    public MaxTimeAggrResult() {
        super(TSDataType.INT64, AggregationType.MAX_TIME);
        this.reset();
    }

    @Override
    public Long getResult() {
        return this.hasCandidateResult() ? Long.valueOf(this.getLongValue()) : null;
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        long maxTimestamp = statistics.getEndTime();
        this.updateMaxTimeResult(maxTimestamp);
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator) {
        this.updateResultFromPageData(batchIterator, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator, long minBound, long maxBound) {
        while (batchIterator.hasNext(minBound, maxBound) && batchIterator.currentTime() < maxBound && batchIterator.currentTime() >= minBound) {
            this.updateMaxTimeResult(batchIterator.currentTime());
            batchIterator.next();
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        Object[] values = dataReader.getValuesInTimestamps(timestamps, length);
        for (int i = length - 1; i >= 0; --i) {
            if (values[i] == null) continue;
            this.updateMaxTimeResult(timestamps[i]);
            return;
        }
    }

    @Override
    public void updateResultUsingValues(long[] timestamps, int length, ValueIterator valueIterator) {
        for (int i = length - 1; i >= 0; --i) {
            if (valueIterator.get(i) == null) continue;
            this.updateMaxTimeResult(timestamps[i]);
            return;
        }
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void merge(AggregateResult another) {
        MaxTimeAggrResult anotherMaxTime = (MaxTimeAggrResult)another;
        if (anotherMaxTime.getResult() != null) {
            this.updateMaxTimeResult(anotherMaxTime.getResult());
        }
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) {
    }

    protected void updateMaxTimeResult(long value) {
        if (!this.hasCandidateResult() || value >= this.getLongValue()) {
            this.setLongValue(value);
        }
    }

    @Override
    public long getTime() {
        return this.getLongValue();
    }
}

