/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import org.apache.iotdb.db.query.aggregation.impl.MinTimeAggrResult;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.utils.ValueIterator;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.IBatchDataIterator;

public class MinTimeDescAggrResult
extends MinTimeAggrResult {
    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        long time = statistics.getStartTime();
        this.setValue(time);
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator, long minBound, long maxBound) {
        while (batchIterator.hasNext(minBound, maxBound) && batchIterator.currentTime() >= minBound) {
            this.setValue(batchIterator.currentTime());
            batchIterator.next();
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        Object[] values = dataReader.getValuesInTimestamps(timestamps, length);
        for (int i = length - 1; i >= 0; --i) {
            if (values[i] == null) continue;
            this.setLongValue(timestamps[i]);
            return;
        }
    }

    @Override
    public void updateResultUsingValues(long[] timestamps, int length, ValueIterator valueIterator) {
        for (int i = length - 1; i >= 0; --i) {
            if (valueIterator.get(i) == null) continue;
            this.setLongValue(timestamps[i]);
            return;
        }
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public boolean isAscending() {
        return false;
    }
}

